/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.ClientSecretRotationExecutor;

public class ClientSecretRotationExecutorFactory
implements ClientPolicyExecutorProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "secret-rotation";
    public static final String SECRET_EXPIRATION_PERIOD = "expiration-period";
    public static final Integer DEFAULT_SECRET_EXPIRATION_PERIOD = Long.valueOf(TimeUnit.DAYS.toSeconds(29L)).intValue();
    public static final String SECRET_REMAINING_ROTATION_PERIOD = "remaining-rotation-period";
    public static final Integer DEFAULT_SECRET_REMAINING_ROTATION_PERIOD = Long.valueOf(TimeUnit.DAYS.toSeconds(10L)).intValue();
    public static final String SECRET_ROTATED_EXPIRATION_PERIOD = "rotated-expiration-period";
    public static final Integer DEFAULT_SECRET_ROTATED_EXPIRATION_PERIOD = Long.valueOf(TimeUnit.DAYS.toSeconds(2L)).intValue();
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getHelpText() {
        return "The executor verifies that secret rotation is enabled for the client. If rotation is enabled, it provides validation of secrets and performs rotation if necessary.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new ClientSecretRotationExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLIENT_SECRET_ROTATION);
    }

    static {
        ProviderConfigProperty secretExpirationPeriod = new ProviderConfigProperty(SECRET_EXPIRATION_PERIOD, "Secret expiration", "When the secret is rotated. The time frequency for generating a new secret. (In seconds)", "String", (Object)DEFAULT_SECRET_EXPIRATION_PERIOD);
        configProperties.add(secretExpirationPeriod);
        ProviderConfigProperty secretRotatedPeriod = new ProviderConfigProperty(SECRET_ROTATED_EXPIRATION_PERIOD, "Rotated Secret expiration", "When secret is rotated, this is the remaining expiration time for the old secret. This value should be always smaller than Secret expiration. When this is set to 0, the old secret will be immediately removed during client rotation (In seconds)", "String", (Object)DEFAULT_SECRET_ROTATED_EXPIRATION_PERIOD);
        configProperties.add(secretRotatedPeriod);
        ProviderConfigProperty secretRemainingExpirationPeriod = new ProviderConfigProperty(SECRET_REMAINING_ROTATION_PERIOD, "Remain Expiration Time", "During dynamic client registration client-update request, the client secret will be automatically rotated if the remaining expiration time of the current secret is smaller than the value specified by this option. This configuration option is relevant only for dynamic client update requests (In seconds)", "String", (Object)DEFAULT_SECRET_REMAINING_ROTATION_PERIOD);
        configProperties.add(secretRemainingExpirationPeriod);
    }
}

