/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.x509;

import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.x509.AbstractClientCertificateFromHttpHeadersLookupFactory;
import org.keycloak.services.x509.NginxProxySslClientCertificateLookup;
import org.keycloak.services.x509.NginxProxyTrustedClientCertificateLookup;
import org.keycloak.services.x509.X509ClientCertificateLookup;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderFactory;

public class NginxProxySslClientCertificateLookupFactory
extends AbstractClientCertificateFromHttpHeadersLookupFactory {
    private static final Logger logger = Logger.getLogger(NginxProxySslClientCertificateLookupFactory.class);
    private static final String PROVIDER = "nginx";
    protected static final String TRUST_PROXY_VERIFICATION = "trust-proxy-verification";
    protected boolean trustProxyVerification;
    private volatile boolean isTruststoreLoaded;
    private Set<X509Certificate> trustedRootCerts;
    private Set<X509Certificate> intermediateCerts;

    @Override
    public void init(Config.Scope config) {
        super.init(config);
        this.trustProxyVerification = config.getBoolean(TRUST_PROXY_VERIFICATION, Boolean.valueOf(false));
        logger.tracev("{0}: ''{1}''", (Object)TRUST_PROXY_VERIFICATION, (Object)this.trustProxyVerification);
        this.isTruststoreLoaded = false;
        this.trustedRootCerts = ConcurrentHashMap.newKeySet();
        this.intermediateCerts = ConcurrentHashMap.newKeySet();
    }

    public X509ClientCertificateLookup create(KeycloakSession session) {
        this.loadKeycloakTrustStore(session);
        if (this.trustProxyVerification) {
            return new NginxProxyTrustedClientCertificateLookup(this.sslClientCertHttpHeader, this.sslChainHttpHeaderPrefix, this.certificateChainLength);
        }
        return new NginxProxySslClientCertificateLookup(this.sslClientCertHttpHeader, this.sslChainHttpHeaderPrefix, this.certificateChainLength, this.intermediateCerts, this.trustedRootCerts, this.isTruststoreLoaded);
    }

    public String getId() {
        return PROVIDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeycloakTrustStore(KeycloakSession kcSession) {
        if (this.isTruststoreLoaded) {
            return;
        }
        NginxProxySslClientCertificateLookupFactory nginxProxySslClientCertificateLookupFactory = this;
        synchronized (nginxProxySslClientCertificateLookupFactory) {
            if (this.isTruststoreLoaded) {
                return;
            }
            logger.debug((Object)" Loading Keycloak truststore ...");
            KeycloakSessionFactory factory = kcSession.getKeycloakSessionFactory();
            TruststoreProviderFactory truststoreFactory = (TruststoreProviderFactory)factory.getProviderFactory(TruststoreProvider.class, "file");
            TruststoreProvider provider = (TruststoreProvider)truststoreFactory.create(kcSession);
            if (provider != null && provider.getTruststore() != null) {
                this.trustedRootCerts.addAll(provider.getRootCertificates().values());
                this.intermediateCerts.addAll(provider.getIntermediateCertificates().values());
                logger.debug((Object)"Keycloak truststore loaded for NGINX x509cert-lookup provider.");
                this.isTruststoreLoaded = true;
            }
        }
    }
}

