/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class ReadOnlyAttributeUnchangedValidator
implements SimpleValidator {
    private static final Logger logger = Logger.getLogger(ReadOnlyAttributeUnchangedValidator.class);
    public static final String ID = "up-readonly-attribute-unchanged";
    public static final String CFG_PATTERN = "pattern";
    public static String UPDATE_READ_ONLY_ATTRIBUTES_REJECTED_MSG = "updateReadOnlyAttributesRejectedMessage";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        AttributeContext attributeContext = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext();
        Map.Entry attribute = attributeContext.getAttribute();
        String key = (String)attribute.getKey();
        Pattern pattern = (Pattern)config.get(CFG_PATTERN);
        if (!pattern.matcher(key).find()) {
            return context;
        }
        List values = (List)input;
        if (values == null) {
            return context;
        }
        UserModel user = attributeContext.getUser();
        String existingValue = user == null ? null : user.getFirstAttribute(key);
        String value = null;
        if (!values.isEmpty()) {
            value = (String)values.get(0);
        }
        if (!this.isUnchanged(existingValue, value)) {
            logger.warnf("Attempt to edit denied attribute '%s' of user '%s'", (Object)pattern, (Object)(user == null ? "new user" : user.getFirstAttribute("username")));
            context.addError(new ValidationError(ID, key, UPDATE_READ_ONLY_ATTRIBUTES_REJECTED_MSG));
        }
        return context;
    }

    private boolean isUnchanged(String existingValue, String value) {
        if (existingValue == null && ObjectUtil.isBlank((CharSequence)value)) {
            return true;
        }
        return ObjectUtil.isEqualOrBothNull((Object)existingValue, (Object)value);
    }
}

