/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.api.capabilities;

import com.openshift.internal.restclient.capability.AbstractCapability;
import com.openshift.restclient.IClient;
import com.openshift.restclient.api.ITypeFactory;
import com.openshift.restclient.api.capabilities.IScalable;
import com.openshift.restclient.apis.autoscaling.models.IScale;
import com.openshift.restclient.model.IReplicationController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ScaleCapability
extends AbstractCapability
implements IScalable {
    private static final Map<String, String> ARG_KINDS = new HashMap<String, String>();
    private static final int MIN_VALUE = 0;
    private static final String CAPABILITY = "scale";
    private final IClient client;
    private IReplicationController rc;
    private final ITypeFactory factory;

    public ScaleCapability(IReplicationController rc, IClient client, ITypeFactory factory) {
        super(rc, client, CAPABILITY);
        this.client = client;
        this.rc = rc;
        this.factory = factory;
    }

    @Override
    public String getName() {
        return ScaleCapability.class.getSimpleName();
    }

    @Override
    public IScale scaleTo(int replicas) {
        replicas = replicas >= 0 ? replicas : 0;
        IScale scale = (IScale)this.factory.stubKind(ARG_KINDS.get(this.rc.getKind()), Optional.of(this.rc.getName()), Optional.of(this.rc.getNamespaceName()));
        scale.setSpecReplicas(replicas);
        return (IScale)this.client.execute(this.factory, "PUT", this.rc.getKind(), this.rc.getNamespaceName(), this.rc.getName(), CAPABILITY, null, scale, Collections.emptyMap());
    }

    static {
        ARG_KINDS.put("DeploymentConfig", "extensions/v1beta1.Scale");
        ARG_KINDS.put("ReplicationController", "autoscaling/v1.Scale");
    }
}

