/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.apis;

import com.openshift.internal.restclient.TypeRegistry;
import com.openshift.internal.restclient.api.models.TypeMeta;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.api.ITypeFactory;
import com.openshift.restclient.api.models.INameSetable;
import com.openshift.restclient.api.models.INamespaceSetable;
import com.openshift.restclient.api.models.ITypeMeta;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class TypeMetaFactory
implements ITypeFactory,
ResourcePropertyKeys {
    private static final String DELIMITER = ".";

    @Override
    public Object stubKind(String kind, Optional<String> name, Optional<String> namespace) {
        if (StringUtils.isEmpty((String)kind)) {
            throw new OpenShiftException("Unable to stub a kind when the kind passed in is empty", new Object[0]);
        }
        try {
            String version = "";
            if (kind.contains(DELIMITER)) {
                int delimeter = kind.indexOf(DELIMITER);
                version = StringUtils.left((String)kind, (int)delimeter);
                kind = StringUtils.right((String)kind, (int)(kind.length() - delimeter - DELIMITER.length()));
            }
            Map<String, String[]> properyKeyMap = ResourcePropertiesRegistry.getInstance().get(version, kind);
            ModelNode node = new ModelNode();
            JBossDmrExtentions.set(node, properyKeyMap, "apiVersion", version);
            JBossDmrExtentions.set(node, properyKeyMap, "kind", kind);
            ITypeMeta instance = null;
            Class<?> clazz = TypeRegistry.getInstance().getRegisteredType(version + '.' + kind);
            if (clazz != null) {
                Constructor<?> constructor = clazz.getConstructor(ModelNode.class, Map.class);
                instance = (ITypeMeta)constructor.newInstance(node, properyKeyMap);
            } else {
                instance = new TypeMeta(node, properyKeyMap);
            }
            if (name.isPresent() && instance instanceof INameSetable) {
                ((INameSetable)((Object)instance)).setName(name.get());
            }
            if (namespace.isPresent() && instance instanceof INamespaceSetable) {
                ((INamespaceSetable)((Object)instance)).setNamespace(namespace.get());
            }
            return instance;
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceFactoryException((Throwable)e, "Unable to stub instance from %s", kind);
        }
    }

    @Override
    public Object createInstanceFrom(String response) {
        try {
            ModelNode node = ModelNode.fromJSONString((String)response);
            String version = node.get("apiVersion").asString();
            String kind = node.get("kind").asString();
            Map<String, String[]> properyKeyMap = ResourcePropertiesRegistry.getInstance().get(version, kind);
            Class<?> clazz = TypeRegistry.getInstance().getRegisteredType(version + '.' + kind);
            try {
                if (clazz != null) {
                    Constructor<?> constructor = clazz.getConstructor(ModelNode.class, Map.class);
                    return constructor.newInstance(node, properyKeyMap);
                }
            }
            catch (Exception e) {
                return new TypeMeta(node, properyKeyMap);
            }
            return new TypeMeta(node, properyKeyMap);
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceFactoryException((Throwable)e, "Unable to create from %s", response);
        }
    }
}

