/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionAdapter;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapAuthenticationSessionAdapter
implements AuthenticationSessionModel {
    private final KeycloakSession session;
    private final MapRootAuthenticationSessionAdapter parent;
    private final String tabId;
    private final MapAuthenticationSessionEntity entity;

    public MapAuthenticationSessionAdapter(KeycloakSession session, MapRootAuthenticationSessionAdapter parent, String tabId, MapAuthenticationSessionEntity entity) {
        this.session = session;
        this.parent = parent;
        this.tabId = tabId;
        this.entity = entity;
    }

    public String getTabId() {
        return this.tabId;
    }

    public RootAuthenticationSessionModel getParentSession() {
        return this.parent;
    }

    public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatus() {
        Map<String, CommonClientSessionModel.ExecutionStatus> executionStatus = this.entity.getExecutionStatuses();
        return executionStatus == null ? Collections.emptyMap() : Collections.unmodifiableMap(executionStatus);
    }

    public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
        Objects.requireNonNull(authenticator, "The provided authenticator can't be null!");
        Objects.requireNonNull(status, "The provided execution status can't be null!");
        this.entity.setExecutionStatus(authenticator, status);
    }

    public void clearExecutionStatus() {
        this.entity.setExecutionStatuses(null);
    }

    public UserModel getAuthenticatedUser() {
        return this.entity.getAuthUserId() == null ? null : this.session.users().getUserById(this.getRealm(), this.entity.getAuthUserId());
    }

    public void setAuthenticatedUser(UserModel user) {
        String userId = user == null ? null : user.getId();
        this.entity.setAuthUserId(userId);
    }

    public Set<String> getRequiredActions() {
        Set<String> requiredActions = this.entity.getRequiredActions();
        return requiredActions == null ? Collections.emptySet() : Collections.unmodifiableSet(requiredActions);
    }

    public void addRequiredAction(String action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.entity.addRequiredAction(action);
    }

    public void removeRequiredAction(String action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.entity.removeRequiredAction(action);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.addRequiredAction(action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.removeRequiredAction(action.name());
    }

    public void setUserSessionNote(String name, String value) {
        this.entity.setUserSessionNote(name, value);
    }

    public Map<String, String> getUserSessionNotes() {
        Map<String, String> userSessionNotes = this.entity.getUserSessionNotes();
        return userSessionNotes == null ? Collections.emptyMap() : Collections.unmodifiableMap(userSessionNotes);
    }

    public void clearUserSessionNotes() {
        this.entity.setUserSessionNotes(null);
    }

    public String getAuthNote(String name) {
        Map<String, String> authNotes = this.entity.getAuthNotes();
        return name != null && authNotes != null ? authNotes.get(name) : null;
    }

    public void setAuthNote(String name, String value) {
        this.entity.setAuthNote(name, value);
    }

    public void removeAuthNote(String name) {
        this.entity.removeAuthNote(name);
    }

    public void clearAuthNotes() {
        this.entity.setAuthNotes(null);
    }

    public String getClientNote(String name) {
        return name != null ? this.getClientNotes().get(name) : null;
    }

    public void setClientNote(String name, String value) {
        this.entity.setClientNote(name, value);
    }

    public void removeClientNote(String name) {
        this.entity.removeClientNote(name);
    }

    public Map<String, String> getClientNotes() {
        Map<String, String> clientNotes = this.entity.getClientNotes();
        return clientNotes == null ? Collections.emptyMap() : Collections.unmodifiableMap(clientNotes);
    }

    public void clearClientNotes() {
        this.entity.setClientNotes(null);
    }

    public Set<String> getClientScopes() {
        Set<String> clientScopes = this.entity.getClientScopes();
        return clientScopes == null ? Collections.emptySet() : Collections.unmodifiableSet(clientScopes);
    }

    public void setClientScopes(Set<String> clientScopes) {
        Objects.requireNonNull(clientScopes, "The provided client scopes set can't be null!");
        this.entity.setClientScopes(clientScopes);
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
    }

    public RealmModel getRealm() {
        return this.parent.getRealm();
    }

    public ClientModel getClient() {
        return this.parent.getRealm().getClientById(this.entity.getClientUUID());
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(String action) {
        this.entity.setAction(action);
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String method) {
        this.entity.setProtocol(method);
    }
}

