/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.realm.MapRealmProvider;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.ProviderEvent;

public class MapRealmProviderFactory
extends AbstractMapProviderFactory<MapRealmProvider, MapRealmEntity, RealmModel>
implements RealmProviderFactory<MapRealmProvider>,
InvalidationHandler {
    public MapRealmProviderFactory() {
        super(RealmModel.class, MapRealmProvider.class);
    }

    @Override
    public MapRealmProvider createNew(KeycloakSession session) {
        return new MapRealmProvider(session, this.getStorage(session));
    }

    public String getHelpText() {
        return "Realm provider";
    }

    public void invalidate(final KeycloakSession session, InvalidationHandler.InvalidableObjectType type, final Object ... params) {
        if (type == AbstractMapProviderFactory.MapProviderObjectType.REALM_AFTER_REMOVE) {
            session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.RealmRemovedEvent(){

                public RealmModel getRealm() {
                    return (RealmModel)params[0];
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }
}

