/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.map.annotations.CollectionKey;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;

@DeepCloner.Root
public interface MapUserFederatedIdentityEntity
extends UpdatableEntity {
    public static MapUserFederatedIdentityEntity fromModel(FederatedIdentityModel model) {
        if (model == null) {
            return null;
        }
        MapUserFederatedIdentityEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapUserFederatedIdentityEntity.class);
        entity.setIdentityProvider(model.getIdentityProvider());
        entity.setUserId(model.getUserId());
        entity.setUserName(model.getUserName().toLowerCase());
        entity.setToken(model.getToken());
        return entity;
    }

    public static FederatedIdentityModel toModel(MapUserFederatedIdentityEntity entity) {
        if (entity == null) {
            return null;
        }
        return new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken());
    }

    public String getToken();

    public void setToken(String var1);

    public String getUserId();

    public void setUserId(String var1);

    @CollectionKey
    public String getIdentityProvider();

    public void setIdentityProvider(String var1);

    public String getUserName();

    public void setUserName(String var1);
}

