/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Image;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.images.ImageData;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.utility.DockerImageName;

enum LocalImagesCache {
    INSTANCE;

    private static final Logger log;
    @VisibleForTesting
    final AtomicBoolean initialized = new AtomicBoolean(false);
    @VisibleForTesting
    final Map<DockerImageName, ImageData> cache = new ConcurrentHashMap<DockerImageName, ImageData>();

    public ImageData get(DockerImageName imageName) {
        this.maybeInitCache(DockerClientFactory.instance().client());
        return this.cache.get(imageName);
    }

    public Optional<ImageData> refreshCache(DockerImageName imageName) {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        if (!this.maybeInitCache(dockerClient)) {
            InspectImageResponse response = null;
            try {
                response = dockerClient.inspectImageCmd(imageName.asCanonicalNameString()).exec();
            }
            catch (NotFoundException e) {
                log.trace("Image {} not found", (Object)imageName, (Object)e);
            }
            if (response != null) {
                ImageData imageData = ImageData.from(response);
                this.cache.put(imageName, imageData);
                return Optional.of(imageData);
            }
            this.cache.remove(imageName);
            return Optional.empty();
        }
        return Optional.ofNullable(this.cache.get(imageName));
    }

    private synchronized boolean maybeInitCache(DockerClient dockerClient) {
        if (!this.initialized.compareAndSet(false, true)) {
            return false;
        }
        if (Boolean.parseBoolean(System.getProperty("useFilter"))) {
            return false;
        }
        this.populateFromList((List)dockerClient.listImagesCmd().exec());
        return true;
    }

    private void populateFromList(List<Image> images) {
        for (Image image : images) {
            String[] repoTags = image.getRepoTags();
            if (repoTags == null) {
                log.debug("repoTags is null, skipping image: {}", (Object)image);
                continue;
            }
            this.cache.putAll(Stream.of(repoTags).distinct().collect(Collectors.toMap(DockerImageName::new, it -> ImageData.from(image))));
        }
    }

    static {
        log = LoggerFactory.getLogger(LocalImagesCache.class);
    }
}

