/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment.metrics;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.runtime.metrics.HibernateMetricsRecorder;
import java.util.List;
import java.util.Optional;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public final class HibernateOrmMetricsProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void metrics(HibernateOrmConfig config, HibernateMetricsRecorder metricsRecorder, List<PersistenceProviderSetUpBuildItem> persistenceUnitsStarted, Optional<MetricsCapabilityBuildItem> metricsConfiguration, BuildProducer<MetricsFactoryConsumerBuildItem> datasourceMetrics) {
        if (config.metricsEnabled && config.statistics.orElse(true).booleanValue() && metricsConfiguration.isPresent()) {
            datasourceMetrics.produce((BuildItem)new MetricsFactoryConsumerBuildItem(metricsRecorder.consumeMetricsFactory()));
        }
    }
}

