/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;

public class ValidationError {
    private final String fieldId;
    private final String message;
    private final String localizedMessageKey;
    private final Object[] localizedMessageParameters;

    public ValidationError(String fieldId, String message, String localizedMessageKey, Object[] localizedMessageParameters) {
        if (message == null) {
            throw new IllegalArgumentException("Message must be set");
        }
        this.fieldId = fieldId;
        this.message = message;
        this.localizedMessageKey = localizedMessageKey;
        this.localizedMessageParameters = localizedMessageParameters;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getLocalizedMessageKey() {
        return this.localizedMessageKey;
    }

    public Object[] getLocalizedMessageParams() {
        return this.localizedMessageParameters;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizedMessage(Properties messagesBundle) {
        if (this.getLocalizedMessageKey() != null) {
            return MessageFormat.format(messagesBundle.getProperty(this.getLocalizedMessageKey(), this.getMessage()), this.getLocalizedMessageParams());
        }
        return this.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationError error = (ValidationError)o;
        return Objects.equals(this.fieldId, error.fieldId) && this.message.equals(error.message) && Objects.equals(this.localizedMessageKey, error.localizedMessageKey) && Arrays.equals(this.localizedMessageParameters, error.localizedMessageParameters);
    }

    public int hashCode() {
        int result = Objects.hash(this.fieldId, this.message, this.localizedMessageKey);
        result = 31 * result + Arrays.hashCode(this.localizedMessageParameters);
        return result;
    }
}

