/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import java.lang.reflect.Method;
import org.locationtech.jts.geom.Geometry;

public class TestBuilderProxy {
    private static final String CLASS_FUNCTIONS_UTIL = "org.locationtech.jtstest.function.FunctionsUtil";
    private static Class<?> tbClass;
    private static Method methodShowIndicator;

    private static void init() {
        if (tbClass != null) {
            return;
        }
        try {
            tbClass = TestBuilderProxy.class.getClassLoader().loadClass(CLASS_FUNCTIONS_UTIL);
            methodShowIndicator = tbClass.getMethod("showIndicator", Geometry.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isActive() {
        TestBuilderProxy.init();
        return tbClass != null;
    }

    public static void showIndicator(Geometry geom) {
        TestBuilderProxy.init();
        if (methodShowIndicator == null) {
            return;
        }
        try {
            methodShowIndicator.invoke(null, geom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

