/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa;

import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;

public abstract class JpaDelegateProvider<T extends JpaRootEntity & AbstractEntity> {
    private T delegate;

    protected JpaDelegateProvider(T delegate) {
        this.delegate = delegate;
    }

    protected T getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(T newDelegate) {
        if (newDelegate == null) {
            throw new ModelIllegalStateException("Unable to retrieve entity: " + this.delegate.getClass().getName() + "#" + this.delegate.getId());
        }
        if (newDelegate instanceof JpaRootVersionedEntity && this.delegate instanceof JpaRootVersionedEntity && ((JpaRootVersionedEntity)newDelegate).getVersion() != ((JpaRootVersionedEntity)this.delegate).getVersion()) {
            throw new ModelIllegalStateException("Version of entity changed between two loads: " + this.delegate.getClass().getName() + "#" + this.delegate.getId());
        }
        this.delegate = newDelegate;
    }
}

