/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.user;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import org.keycloak.models.UserModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserEntity;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.storage.StorageId;

public class JpaUserModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaUserEntity, UserModel, JpaUserModelCriteriaBuilder> {
    public JpaUserModelCriteriaBuilder() {
        super(JpaUserModelCriteriaBuilder::new);
    }

    private JpaUserModelCriteriaBuilder(JpaPredicateFunction<JpaUserEntity> predicateFunc) {
        super(JpaUserModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaUserModelCriteriaBuilder compare(SearchableModelField<? super UserModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == UserModel.SearchableFields.USERNAME_CASE_INSENSITIVE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get("username"), (Object)value[0].toString().toLowerCase()));
                }
                if (modelField == UserModel.SearchableFields.USERNAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.or((Expression)cb.and((Expression)cb.equal((Expression)root.get("usernameWithCase"), value[0]), (Expression)cb.ge((Expression)root.get("entityVersion"), (Number)2)), (Expression)cb.and((Expression)cb.equal((Expression)root.get("username"), (Object)value[0].toString().toLowerCase()), (Expression)cb.le((Expression)root.get("entityVersion"), (Number)1))));
                }
                if (modelField == UserModel.SearchableFields.REALM_ID || modelField == UserModel.SearchableFields.EMAIL || modelField == UserModel.SearchableFields.FEDERATION_LINK) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == UserModel.SearchableFields.ENABLED || modelField == UserModel.SearchableFields.EMAIL_VERIFIED) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == UserModel.SearchableFields.IDP_AND_USER) {
                    if (value == null || value.length == 0 || value.length > 2) {
                        throw new CriterionNotSupportedException(modelField, op, "Invalid arguments, expected (idp_alias) or (idp_alias, idp_user), got: " + Arrays.toString(value));
                    }
                    if (value.length == 1) {
                        return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("federatedIdentities", JoinType.LEFT).get("identityProvider"), value[0]));
                    }
                    if (value[0] == null) {
                        return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("federatedIdentities", JoinType.LEFT).get("userId"), value[1]));
                    }
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("federatedIdentities", JoinType.LEFT);
                        return cb.and((Expression)cb.equal((Expression)join.get("identityProvider"), value[0]), (Expression)cb.equal((Expression)join.get("userId"), value[1]));
                    });
                }
                if (modelField == UserModel.SearchableFields.ASSIGNED_GROUP) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("groupIds", JoinType.LEFT), value[0]));
                }
                if (modelField == UserModel.SearchableFields.ASSIGNED_ROLE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("roleIds", JoinType.LEFT), value[0]));
                }
                if (modelField == UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fServiceAccountClientLink")}), value[0]));
                }
                if (modelField == UserModel.SearchableFields.CONSENT_FOR_CLIENT) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("consents", JoinType.LEFT).get("clientId"), value[0]));
                }
                if (modelField == UserModel.SearchableFields.CONSENT_CLIENT_FEDERATION_LINK) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> {
                        String providerId = new StorageId((String)value[0], "").getId() + "%";
                        return cb.like((Expression)root.join("consents", JoinType.LEFT).get("clientId"), providerId);
                    });
                }
                if (modelField == UserModel.SearchableFields.CONSENT_WITH_CLIENT_SCOPE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("consents", JoinType.LEFT);
                        return cb.isTrue(cb.function("@>", Boolean.TYPE, new Expression[]{cb.function("->", JsonbType.class, new Expression[]{join.get("metadata"), cb.literal((Object)"fGrantedClientScopesIds")}), cb.literal((Object)this.convertToJson(value[0]))}));
                    });
                }
                if (modelField == UserModel.SearchableFields.ATTRIBUTE) {
                    this.validateValue(value, modelField, op, String.class, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("attributes", JoinType.LEFT);
                        return cb.and(new Predicate[]{cb.equal((Expression)join.get("name"), value[0]), this.hashExpression(cb, join, "value_hash", value[1]), cb.equal((Expression)join.get("value"), value[1])});
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField == UserModel.SearchableFields.FIRST_NAME || modelField == UserModel.SearchableFields.LAST_NAME || modelField == UserModel.SearchableFields.EMAIL) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                if (modelField == UserModel.SearchableFields.USERNAME_CASE_INSENSITIVE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.like((Expression)root.get("username"), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case LIKE: {
                if (modelField == UserModel.SearchableFields.USERNAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.or((Expression)cb.and((Expression)cb.like((Expression)root.get("usernameWithCase"), value[0].toString()), (Expression)cb.ge((Expression)root.get("entityVersion"), (Number)2)), (Expression)cb.and((Expression)cb.like((Expression)root.get("username"), value[0].toString()), (Expression)cb.le((Expression)root.get("entityVersion"), (Number)1))));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == UserModel.SearchableFields.ASSIGNED_GROUP) {
                    Collection<? super UserModel> collectionValues = this.getValuesForInOperator(value, modelField);
                    if (collectionValues.isEmpty()) {
                        return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.join("groupIds", JoinType.LEFT));
                        collectionValues.forEach(groupId -> {
                            if (!(groupId instanceof String)) {
                                throw new CriterionNotSupportedException(modelField, op, "Invalid type. Expected String, got " + groupId.getClass());
                            }
                            in.value((Object)groupId.toString());
                        });
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NOT_EXISTS: {
                if (modelField == UserModel.SearchableFields.SERVICE_ACCOUNT_CLIENT) {
                    return new JpaUserModelCriteriaBuilder((cb, query, root) -> cb.isNull(cb.function("->>", String.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fServiceAccountClientLink")})));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

