/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.js;

import java.util.function.BiFunction;
import javax.script.ScriptContext;
import javax.script.SimpleScriptContext;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.scripting.EvaluatableScriptAdapter;

class JSPolicyProvider
implements PolicyProvider {
    private final BiFunction<AuthorizationProvider, Policy, EvaluatableScriptAdapter> evaluatableScript;

    JSPolicyProvider(BiFunction<AuthorizationProvider, Policy, EvaluatableScriptAdapter> evaluatableScript) {
        this.evaluatableScript = evaluatableScript;
    }

    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        AuthorizationProvider authorization = evaluation.getAuthorizationProvider();
        EvaluatableScriptAdapter adapter = this.evaluatableScript.apply(authorization, policy);
        try {
            SimpleScriptContext context = new SimpleScriptContext();
            context.setAttribute("$evaluation", evaluation, 100);
            adapter.eval((ScriptContext)context);
        }
        catch (Exception e) {
            throw new RuntimeException("Error evaluating JS Policy [" + policy.getName() + "].", e);
        }
    }

    public void close() {
    }
}

