/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerPort;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.runtime.LaunchMode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;

public class ContainerLocator {
    private static final Logger log = Logger.getLogger(ContainerLocator.class);
    private static final BiPredicate<ContainerPort, Integer> hasMatchingPort = (containerPort, port) -> containerPort.getPrivatePort() != null && containerPort.getPublicPort() != null && containerPort.getPrivatePort().equals(port);
    private final String devServiceLabel;
    private final int port;

    public ContainerLocator(String devServiceLabel, int port) {
        this.devServiceLabel = devServiceLabel;
        this.port = port;
    }

    private Optional<Container> lookup(String expectedLabelValue) {
        return ((List)DockerClientFactory.lazyClient().listContainersCmd().exec()).stream().filter(container -> expectedLabelValue.equals(container.getLabels().get(this.devServiceLabel))).findAny();
    }

    private Optional<ContainerPort> getMappedPort(Container container, int port) {
        return Arrays.stream(container.getPorts()).filter(containerPort -> hasMatchingPort.test((ContainerPort)containerPort, port)).findAny();
    }

    public Optional<ContainerAddress> locateContainer(String serviceName, boolean shared, LaunchMode launchMode) {
        if (shared && launchMode == LaunchMode.DEVELOPMENT) {
            return this.lookup(serviceName).flatMap(container -> this.getMappedPort((Container)container, this.port).flatMap(containerPort -> Optional.ofNullable(containerPort.getPublicPort()).map(port -> {
                ContainerAddress containerAddress = new ContainerAddress(container.getId(), DockerClientFactory.instance().dockerHostIpAddress(), containerPort.getPublicPort());
                log.infof("Dev Services container found: %s (%s). Connecting to: %s.", (Object)container.getId(), (Object)container.getImage(), (Object)containerAddress.getUrl());
                return containerAddress;
            })));
        }
        return Optional.empty();
    }

    public Optional<Integer> locatePublicPort(String serviceName, boolean shared, LaunchMode launchMode, int privatePort) {
        if (shared && launchMode == LaunchMode.DEVELOPMENT) {
            return this.lookup(serviceName).flatMap(container -> this.getMappedPort((Container)container, privatePort)).map(ContainerPort::getPublicPort);
        }
        return Optional.empty();
    }
}

