/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class PropertyInjector {
    private final Class<?> cls;
    private final Map<String, Method> propertySetter = new HashMap<String, Method>();

    public PropertyInjector(Class<?> cls) {
        this.cls = cls;
        for (Method method : cls.getMethods()) {
            String name = method.getName();
            if (method.getParameterCount() == 1 && name.startsWith("set")) {
                this.propertySetter.put(name.substring(3), method);
                continue;
            }
            if (method.getParameterCount() != 2 || !"setProperty".equals(name)) continue;
            this.propertySetter.put("Property", method);
        }
    }

    public void inject(Object target, String propertyName, String propertyValue) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        String realName = propertyName.substring(0, 1).toUpperCase(Locale.ROOT) + propertyName.substring(1);
        if (this.propertySetter.containsKey(realName)) {
            Method method = this.propertySetter.get(realName);
            method.invoke(target, this.typeConvert(propertyValue, method.getParameterTypes()[0]));
        } else if (this.propertySetter.containsKey("Property")) {
            this.cls.getMethod("setProperty", propertyName.getClass(), propertyValue.getClass()).invoke(target, propertyName, propertyValue);
        } else {
            throw new NoSuchMethodException("No setter in class " + this.cls.getName());
        }
    }

    public Set<String> availableProperties() {
        return this.propertySetter.keySet();
    }

    private static Properties typeConvertProperties(String properties) {
        if (properties == null) {
            return new Properties();
        }
        if ((properties = properties.trim()).isEmpty()) {
            return new Properties();
        }
        Properties result = new Properties();
        for (String property : properties.split(";")) {
            String[] keyValue = property.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Can't convert properties '" + properties + "' to " + Properties.class.getName());
            }
            result.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return result;
    }

    private Object typeConvert(String value, Class<?> target) {
        if (target == String.class) {
            return value;
        }
        if (Boolean.class.isAssignableFrom(target) || Boolean.TYPE.isAssignableFrom(target)) {
            return Boolean.parseBoolean(value);
        }
        if (Character.class.isAssignableFrom(target) || Character.TYPE.isAssignableFrom(target)) {
            return Character.valueOf(value.charAt(0));
        }
        if (Short.class.isAssignableFrom(target) || Short.TYPE.isAssignableFrom(target)) {
            return Short.parseShort(value);
        }
        if (Integer.class.isAssignableFrom(target) || Integer.TYPE.isAssignableFrom(target)) {
            return Integer.parseInt(value);
        }
        if (Long.class.isAssignableFrom(target) || Long.TYPE.isAssignableFrom(target)) {
            return Long.parseLong(value);
        }
        if (Float.class.isAssignableFrom(target) || Float.TYPE.isAssignableFrom(target)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.isAssignableFrom(target) || Double.TYPE.isAssignableFrom(target)) {
            return Double.parseDouble(value);
        }
        if (Class.class.isAssignableFrom(target)) {
            try {
                return this.cls.getClassLoader().loadClass(value);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("ClassNotFoundException: " + e.getMessage());
            }
        }
        if (Properties.class.isAssignableFrom(target)) {
            return PropertyInjector.typeConvertProperties(value);
        }
        throw new IllegalArgumentException("Can't convert to " + target.getName());
    }
}

