/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.jdbc.internal.Monitor;

public final class CompletionStageUtil {
    private static final Flow.Subscription NO_OP_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long l2) {
        }

        @Override
        public void cancel() {
        }
    };
    public static final CompletableFuture<Void> VOID_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);

    private CompletionStageUtil() {
    }

    public static void acceptCompletion(CompletionHandler completionHandler) {
        try {
            completionHandler.handle();
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    public static <T> T handleCompletion(T t2, Throwable throwable, CompletionHandler completionHandler) {
        CompletionStageUtil.acceptCompletion(completionHandler);
        if (throwable == null) {
            return t2;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T> BiFunction<T, Throwable, T> completionHandler(CompletionHandler completionHandler) {
        return (object, throwable) -> CompletionStageUtil.handleCompletion(object, throwable, completionHandler);
    }

    public static <T, U> U handleNormalCompletion(T t2, NormalCompletionHandler<T, U> normalCompletionHandler) {
        try {
            return normalCompletionHandler.handle(t2);
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    public static <T, U> U handleNormalCompletion(T t2, Throwable throwable, NormalCompletionHandler<T, U> normalCompletionHandler) {
        if (throwable == null) {
            return CompletionStageUtil.handleNormalCompletion(t2, normalCompletionHandler);
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T, U> Function<T, U> normalCompletionHandler(NormalCompletionHandler<T, U> normalCompletionHandler) {
        return object -> CompletionStageUtil.handleNormalCompletion(object, normalCompletionHandler);
    }

    public static <E extends Throwable, T> T handleExceptionalCompletion(Throwable throwable, Class<E> clazz, ExceptionalCompletionHandler<? super E, ? extends T> exceptionalCompletionHandler) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = CompletionStageUtil.unwrapCompletionException(throwable);
        if (clazz.isInstance(throwable2)) {
            try {
                return exceptionalCompletionHandler.handle(throwable2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
        throw new CompletionException(throwable2);
    }

    public static <E extends Throwable, T> Function<Throwable, T> exceptionalCompletionHandler(Class<E> clazz, ExceptionalCompletionHandler<? super E, T> exceptionalCompletionHandler) {
        return throwable -> CompletionStageUtil.handleExceptionalCompletion(throwable, clazz, exceptionalCompletionHandler);
    }

    public static <T, E extends Throwable, U> U handleCompletion(T t2, NormalCompletionHandler<? super T, U> normalCompletionHandler, Throwable throwable, Class<E> clazz, ExceptionalCompletionHandler<? super E, ? extends U> exceptionalCompletionHandler) {
        return throwable == null ? CompletionStageUtil.handleNormalCompletion(t2, normalCompletionHandler) : CompletionStageUtil.handleExceptionalCompletion(throwable, clazz, exceptionalCompletionHandler);
    }

    public static <T, E extends Throwable, U> BiFunction<T, Throwable, U> completionHandler(NormalCompletionHandler<T, U> normalCompletionHandler, Class<E> clazz, ExceptionalCompletionHandler<? super E, U> exceptionalCompletionHandler) {
        return (object, throwable) -> CompletionStageUtil.handleCompletion(object, normalCompletionHandler, throwable, clazz, exceptionalCompletionHandler);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static <T> CompletionStage<T> completedStage(T t2) {
        return CompletableFuture.completedStage(t2);
    }

    public static <T> CompletionStage<T> failedStage(Throwable throwable) {
        return CompletableFuture.failedStage(throwable);
    }

    public static Flow.Publisher<Void> newNoItemPublisher(CompletionStage<Void> completionStage, Executor executor) {
        return CompletionStageUtil.newBatchItemPublisher(completionStage, void_ -> NoItemIterator.INSTANCE, executor);
    }

    public static <T> Flow.Publisher<T> newSingleItemPublisher(CompletionStage<T> completionStage, Executor executor) {
        return CompletionStageUtil.newBatchItemPublisher(completionStage, object -> new SingleItemIterator<Object>(object), executor);
    }

    public static <T, U> Flow.Publisher<U> newBatchItemPublisher(CompletionStage<T> completionStage, Function<T, Iterator<U>> function, Executor executor) {
        return new BatchItemPublisher<T, U>(completionStage, function, executor);
    }

    public static <T> CompletionStage<T> subscribeForSingleItem(Flow.Publisher<T> publisher) {
        final CompletableFuture completableFuture = new CompletableFuture();
        publisher.subscribe(new Flow.Subscriber<T>(){
            Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(T t2) {
                this.subscription.cancel();
                completableFuture.complete(t2);
            }

            @Override
            public void onComplete() {
                completableFuture.complete(null);
            }

            @Override
            public void onError(Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    public static void callOnComplete(CompletionStage<Void> completionStage, Consumer<Throwable> consumer) {
        CompletionStageUtil.callOnComplete(completionStage, (T void_, Throwable throwable) -> consumer.accept((Throwable)throwable));
    }

    public static <T> void callOnComplete(CompletionStage<T> completionStage, BiConsumer<T, Throwable> biConsumer) {
        CompletableFuture<T> completableFuture = completionStage.toCompletableFuture();
        if (completableFuture.isDone() && !completableFuture.isCompletedExceptionally()) {
            biConsumer.accept(completableFuture.join(), null);
        } else {
            completableFuture.whenComplete((BiConsumer)biConsumer);
        }
    }

    public static <T extends Throwable> T suppress(T t2, Throwable throwable) {
        if (throwable != null) {
            t2.addSuppressed(throwable);
        }
        return t2;
    }

    private static class IteratorSubscription<T>
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final Iterator<T> itemIterator;
        private final Executor executor;
        private final Monitor signalMonitor = Monitor.newInstance();
        private final AtomicLong demand = new AtomicLong(0L);
        private final Consumer<IteratorSubscription> onCancel;
        private volatile boolean isCancelled = false;

        private IteratorSubscription(Flow.Subscriber<? super T> subscriber, Iterator<T> iterator, Executor executor, Consumer<IteratorSubscription> consumer) {
            this.subscriber = subscriber;
            this.itemIterator = iterator;
            this.executor = executor;
            this.onCancel = consumer;
        }

        @Override
        public void request(long l2) {
            if (this.isCancelled) {
                return;
            }
            if (l2 < 1L) {
                this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + l2));
            } else {
                boolean bl;
                boolean bl2 = bl = 0L == this.demand.getAndUpdate(l3 -> {
                    long l4 = l3 + l2;
                    return l4 > 0L ? l4 : Long.MAX_VALUE;
                });
                if (bl) {
                    this.executor.execute(this::emitItems);
                }
            }
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
            this.onCancel.accept(this);
        }

        public boolean equals(Object object) {
            return object instanceof IteratorSubscription && ((IteratorSubscription)object).subscriber.equals(this.subscriber);
        }

        public int hashCode() {
            return this.subscriber.hashCode();
        }

        private final void emitItems() {
            long l2 = this.demand.get();
            while (l2 > 0L) {
                int n2 = 0;
                while ((long)n2 < l2 && this.itemIterator.hasNext()) {
                    this.emitItem(this.itemIterator.next());
                    ++n2;
                }
                if (!this.itemIterator.hasNext()) {
                    this.emitComplete();
                    return;
                }
                long l4 = l2;
                l2 = this.demand.updateAndGet(l3 -> {
                    if (l3 == Long.MAX_VALUE) {
                        return Long.MAX_VALUE;
                    }
                    return l3 - l4;
                });
            }
        }

        private final void emitItem(T t2) {
            try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                try {
                    this.subscriber.onNext(t2);
                }
                catch (Throwable throwable) {
                    this.cancel();
                }
            }
        }

        private final void emitError(Throwable throwable) {
            try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.subscriber.onError(throwable);
                }
                catch (Throwable throwable2) {
                }
            }
        }

        private final void emitComplete() {
            try (Monitor.CloseableLock closeableLock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled) {
                    return;
                }
                this.cancel();
                try {
                    this.subscriber.onComplete();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    private static final class BatchItemPublisher<U, T>
    implements Flow.Publisher<T> {
        private final CompletionStage<U> batchItemStage;
        private final Function<U, Iterator<T>> iteratorFunction;
        private final Executor executor;
        private final CopyOnWriteArraySet<IteratorSubscription> subscriptions = new CopyOnWriteArraySet();

        private BatchItemPublisher(CompletionStage<U> completionStage, Function<U, Iterator<T>> function, Executor executor) {
            this.batchItemStage = completionStage;
            this.iteratorFunction = function;
            this.executor = executor;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            Objects.requireNonNull(subscriber);
            try {
                this.executor.execute(() -> CompletionStageUtil.callOnComplete(this.batchItemStage, (object, throwable) -> {
                    if (throwable != null) {
                        this.subscribeToFailedBatch(subscriber, (Throwable)throwable);
                    } else {
                        this.subscribeToBatch(subscriber, object);
                    }
                }));
            }
            catch (Throwable throwable) {
                this.subscribeToFailedBatch(subscriber, throwable);
            }
        }

        private final void subscribeToBatch(Flow.Subscriber<? super T> subscriber, U u2) {
            Iterator<T> iterator = this.iteratorFunction.apply(u2);
            IteratorSubscription<T> iteratorSubscription2 = new IteratorSubscription<T>(subscriber, iterator, this.executor, this.subscriptions::remove);
            if (!this.subscriptions.add(iteratorSubscription2)) {
                this.subscriptions.stream().filter(iteratorSubscription2::equals).findFirst().ifPresent(iteratorSubscription -> iteratorSubscription.emitError(new IllegalStateException("Subscriber argument to subscribe(Subscriber) is already subscribed")));
            } else {
                try (Monitor.CloseableLock closeableLock = iteratorSubscription2.signalMonitor.acquireCloseableLock();){
                    subscriber.onSubscribe(iteratorSubscription2);
                    if (u2 == null) {
                        iteratorSubscription2.emitComplete();
                    }
                }
                catch (Throwable throwable) {
                    iteratorSubscription2.cancel();
                }
            }
        }

        private final void subscribeToFailedBatch(Flow.Subscriber<? super T> subscriber, Throwable throwable) {
            try {
                subscriber.onSubscribe(NO_OP_SUBSCRIPTION);
                subscriber.onError(CompletionStageUtil.unwrapCompletionException(throwable));
            }
            catch (Throwable throwable2) {
            }
        }
    }

    private static final class SingleItemIterator<T>
    implements Iterator<T> {
        private final T item;
        boolean hasNext = true;

        private SingleItemIterator(T t2) {
            this.item = t2;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            this.hasNext = false;
            return this.item;
        }
    }

    private static final class NoItemIterator
    implements Iterator<Void> {
        private static final NoItemIterator INSTANCE = new NoItemIterator();

        private NoItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Void next() {
            throw new NoSuchElementException();
        }
    }

    @FunctionalInterface
    public static interface ExceptionalCompletionHandler<E extends Throwable, T>
    extends Function<E, T> {
        public T handle(E var1) throws Exception;

        @Override
        default public T apply(E e2) {
            try {
                return this.handle(e2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface NormalCompletionHandler<T, U>
    extends Function<T, U> {
        public U handle(T var1) throws Exception;

        @Override
        default public U apply(T t2) {
            try {
                return this.handle(t2);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler
    extends Runnable {
        public void handle() throws Exception;

        @Override
        default public void run() {
            try {
                this.handle();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }
}

