"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEK_IN_MILLI_SECS = exports.STACK_TRACE_PATTERN = exports.SORT_DIRECTION = exports.SEC_IN_MILLI_SECS = exports.SAMPLE_TYPE = exports.REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPES = exports.OPENSEARCH_EXCEPTION_PREFIX = exports.MODEL_ID_FIELD = exports.MIN_IN_MILLI_SECS = exports.MAX_MONITORS = exports.MAX_DETECTORS = exports.MAX_ANOMALY_GRADE_FIELD = exports.MAX_ALERTS = exports.KEY_FIELD = exports.HOUR_IN_MILLI_SECS = exports.HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPES = exports.HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.ENTITY_VALUE_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = exports.ENTITY_LIST_FIELD = exports.ENTITY_LIST_DELIMITER = exports.ENTITY_FIELD = exports.DOC_COUNT_FIELD = exports.DETECTOR_STATE = exports.DEFAULT_HEADERS = exports.DAY_IN_MILLI_SECS = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CLUSTER = exports.API = exports.ALERTING_API_ROUTE_PREFIX = exports.AD_DOC_FIELDS = exports.AD_API_ROUTE_PREFIX = void 0;

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
const AD_API_ROUTE_PREFIX = '/_plugins/_anomaly_detection';
exports.AD_API_ROUTE_PREFIX = AD_API_ROUTE_PREFIX;
const ALERTING_API_ROUTE_PREFIX = '/_plugins/_alerting';
exports.ALERTING_API_ROUTE_PREFIX = ALERTING_API_ROUTE_PREFIX;
const API = {
  DETECTOR_BASE: `${AD_API_ROUTE_PREFIX}/detectors`,
  ALERTING_BASE: `${ALERTING_API_ROUTE_PREFIX}/monitors`
};
exports.API = API;
const DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch Dashboards'
};
exports.DEFAULT_HEADERS = DEFAULT_HEADERS;
const SEC_IN_MILLI_SECS = 1000;
exports.SEC_IN_MILLI_SECS = SEC_IN_MILLI_SECS;
const MIN_IN_MILLI_SECS = 60 * SEC_IN_MILLI_SECS;
exports.MIN_IN_MILLI_SECS = MIN_IN_MILLI_SECS;
const HOUR_IN_MILLI_SECS = 60 * MIN_IN_MILLI_SECS;
exports.HOUR_IN_MILLI_SECS = HOUR_IN_MILLI_SECS;
const DAY_IN_MILLI_SECS = 24 * HOUR_IN_MILLI_SECS;
exports.DAY_IN_MILLI_SECS = DAY_IN_MILLI_SECS;
const WEEK_IN_MILLI_SECS = 7 * DAY_IN_MILLI_SECS;
exports.WEEK_IN_MILLI_SECS = WEEK_IN_MILLI_SECS;
let CLUSTER;
exports.CLUSTER = CLUSTER;

(function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["AES_AD"] = "aes_ad";
  CLUSTER["DATA"] = "data";
})(CLUSTER || (exports.CLUSTER = CLUSTER = {}));

let SORT_DIRECTION;
exports.SORT_DIRECTION = SORT_DIRECTION;

(function (SORT_DIRECTION) {
  SORT_DIRECTION["ASC"] = "asc";
  SORT_DIRECTION["DESC"] = "desc";
})(SORT_DIRECTION || (exports.SORT_DIRECTION = SORT_DIRECTION = {}));

let AD_DOC_FIELDS;
exports.AD_DOC_FIELDS = AD_DOC_FIELDS;

(function (AD_DOC_FIELDS) {
  AD_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  AD_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  AD_DOC_FIELDS["DETECTOR_ID"] = "detector_id";
  AD_DOC_FIELDS["TASK_ID"] = "task_id";
  AD_DOC_FIELDS["DETECTOR_NAME"] = "name";
  AD_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  AD_DOC_FIELDS["ANOMALY_GRADE"] = "anomaly_grade";
  AD_DOC_FIELDS["ERROR"] = "error";
  AD_DOC_FIELDS["INDICES"] = "indices";
})(AD_DOC_FIELDS || (exports.AD_DOC_FIELDS = AD_DOC_FIELDS = {}));

const MAX_DETECTORS = 1000;
exports.MAX_DETECTORS = MAX_DETECTORS;
const MAX_MONITORS = 1000;
exports.MAX_MONITORS = MAX_MONITORS;
const MAX_ALERTS = 1000; // TODO: maybe move types/interfaces/constants/helpers shared between client and server
// side as many as possible into single place

exports.MAX_ALERTS = MAX_ALERTS;
let DETECTOR_STATE;
exports.DETECTOR_STATE = DETECTOR_STATE;

(function (DETECTOR_STATE) {
  DETECTOR_STATE["DISABLED"] = "Stopped";
  DETECTOR_STATE["INIT"] = "Initializing";
  DETECTOR_STATE["RUNNING"] = "Running";
  DETECTOR_STATE["FINISHED"] = "Finished";
  DETECTOR_STATE["FEATURE_REQUIRED"] = "Feature required";
  DETECTOR_STATE["INIT_FAILURE"] = "Initialization failure";
  DETECTOR_STATE["UNEXPECTED_FAILURE"] = "Unexpected failure";
  DETECTOR_STATE["FAILED"] = "Failed";
})(DETECTOR_STATE || (exports.DETECTOR_STATE = DETECTOR_STATE = {}));

let SAMPLE_TYPE;
exports.SAMPLE_TYPE = SAMPLE_TYPE;

(function (SAMPLE_TYPE) {
  SAMPLE_TYPE["HTTP_RESPONSES"] = "http-responses";
  SAMPLE_TYPE["HOST_HEALTH"] = "host-health";
  SAMPLE_TYPE["ECOMMERCE"] = "ecommerce";
})(SAMPLE_TYPE || (exports.SAMPLE_TYPE = SAMPLE_TYPE = {}));

const ENTITY_FIELD = 'entity';
exports.ENTITY_FIELD = ENTITY_FIELD;
const ENTITY_VALUE_PATH_FIELD = 'entity.value';
exports.ENTITY_VALUE_PATH_FIELD = ENTITY_VALUE_PATH_FIELD;
const ENTITY_NAME_PATH_FIELD = 'entity.name';
exports.ENTITY_NAME_PATH_FIELD = ENTITY_NAME_PATH_FIELD;
const MODEL_ID_FIELD = 'model_id';
exports.MODEL_ID_FIELD = MODEL_ID_FIELD;
const DOC_COUNT_FIELD = 'doc_count';
exports.DOC_COUNT_FIELD = DOC_COUNT_FIELD;
const KEY_FIELD = 'key';
exports.KEY_FIELD = KEY_FIELD;
const ENTITY_LIST_FIELD = 'entity_list';
exports.ENTITY_LIST_FIELD = ENTITY_LIST_FIELD;
const MAX_ANOMALY_GRADE_FIELD = 'max_anomaly_grade'; // y-axis values in the heatmap chart should be in the form:
// <category-field-value-1><br><category-field-value-2>

exports.MAX_ANOMALY_GRADE_FIELD = MAX_ANOMALY_GRADE_FIELD;
const ENTITY_LIST_DELIMITER = '<br>'; // when hovering over a cell, the entity list should be in the form:
// <category-field-name-1>: <category-field-value-1>, <category-field-name-2>: <category-field-value-2>

exports.ENTITY_LIST_DELIMITER = ENTITY_LIST_DELIMITER;
const HEATMAP_CELL_ENTITY_DELIMITER = ', ';
exports.HEATMAP_CELL_ENTITY_DELIMITER = HEATMAP_CELL_ENTITY_DELIMITER;
const HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = ': ';
exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER;
const STACK_TRACE_PATTERN = '.java:';
exports.STACK_TRACE_PATTERN = STACK_TRACE_PATTERN;
const OPENSEARCH_EXCEPTION_PREFIX = 'org.opensearch.OpenSearchException: ';
exports.OPENSEARCH_EXCEPTION_PREFIX = OPENSEARCH_EXCEPTION_PREFIX;
const REALTIME_TASK_TYPE_PREFIX = 'REALTIME';
exports.REALTIME_TASK_TYPE_PREFIX = REALTIME_TASK_TYPE_PREFIX;
const HISTORICAL_TASK_TYPE_PREFIX = 'HISTORICAL';
exports.HISTORICAL_TASK_TYPE_PREFIX = HISTORICAL_TASK_TYPE_PREFIX;
const REALTIME_TASK_TYPES = ['REALTIME_HC_DETECTOR', 'REALTIME_SINGLE_ENTITY'];
exports.REALTIME_TASK_TYPES = REALTIME_TASK_TYPES;
const HISTORICAL_TASK_TYPES = ['HISTORICAL_SINGLE_ENTITY', 'HISTORICAL_HC_DETECTOR', 'HISTORICAL'];
exports.HISTORICAL_TASK_TYPES = HISTORICAL_TASK_TYPES;
const CUSTOM_AD_RESULT_INDEX_PREFIX = 'opensearch-ad-plugin-result-';
exports.CUSTOM_AD_RESULT_INDEX_PREFIX = CUSTOM_AD_RESULT_INDEX_PREFIX;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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