"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsAstBuilder = void 0;

var _lodash = require("lodash");

var _AbstractParseTreeVisitor = require("antlr4ts/tree/AbstractParseTreeVisitor");

var _node = require("../node");

var _aggragations = require("../tree/aggragations");

var _expression = require("../expression");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class StatsAstBuilder extends _AbstractParseTreeVisitor.AbstractParseTreeVisitor {
  defaultResult() {
    return new _node.PPLNode('default', []);
  }

  visitRoot(ctx) {
    if (!ctx.pplStatement()) return this.defaultResult();
    return this.visitPplStatement(ctx.pplStatement());
  }

  visitPplStatement(ctx) {
    let statsTree = this.defaultResult();
    ctx.commands().map(pplCommandContext => {
      if ((0, _lodash.isFunction)(this.visitChildren(pplCommandContext).getName) && (0, _lodash.isEqual)(this.visitChildren(pplCommandContext).getName(), 'stats_command')) statsTree = this.visitChildren(pplCommandContext);
    });
    return statsTree;
  }

  visitCommands(ctx) {
    if (ctx.statsCommand()) {
      return this.visitStatsCommand(ctx.statsCommand());
    }

    return this.defaultResult();
  }
  /**
   * Stats command
   */


  visitStatsCommand(ctx) {
    var _ctx$PARTITIONS, _ctx$integerLiteral, _ctx$ALLNUM, _ctx$DELIM, _ctx$DEDUP_SPLITVALUE, _ctx$stop;

    return new _aggragations.Aggregations('stats_command', [], ctx.PARTITIONS() && ctx.integerLiteral() ? {
      keyword: (_ctx$PARTITIONS = ctx.PARTITIONS()) === null || _ctx$PARTITIONS === void 0 ? void 0 : _ctx$PARTITIONS.text,
      sign: '=',
      value: (_ctx$integerLiteral = ctx.integerLiteral()) === null || _ctx$integerLiteral === void 0 ? void 0 : _ctx$integerLiteral.text
    } : {}, // visit partitions partial
    ctx.ALLNUM() && ctx.booleanLiteral() ? {
      keyword: (_ctx$ALLNUM = ctx.ALLNUM()) === null || _ctx$ALLNUM === void 0 ? void 0 : _ctx$ALLNUM.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[0])
    } : {}, // visit allnum partial
    ctx.DELIM() && ctx.stringLiteral() ? {
      keyword: (_ctx$DELIM = ctx.DELIM()) === null || _ctx$DELIM === void 0 ? void 0 : _ctx$DELIM.text,
      sign: '=',
      value: this.visitStringLiteral(ctx.stringLiteral())
    } : '', // visit delim partial
    ctx.statsAggTerm().map(aggTermAlternative => this.visitStatsAggTerm(aggTermAlternative)), // visit statsAggTerm
    ctx.statsByClause() ? this.visitStatsByClause(ctx.statsByClause()) : {}, // visit group list
    ctx.DEDUP_SPLITVALUES() && ctx.booleanLiteral() ? {
      keyword: (_ctx$DEDUP_SPLITVALUE = ctx.DEDUP_SPLITVALUES()) === null || _ctx$DEDUP_SPLITVALUE === void 0 ? void 0 : _ctx$DEDUP_SPLITVALUE.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[1])
    } : '', // visit dedup split value
    {
      start: ctx.start.startIndex,
      end: (_ctx$stop = ctx.stop) === null || _ctx$stop === void 0 ? void 0 : _ctx$stop.stopIndex
    } // stats start/end indices in query for later query concatenation
    );
  }

  visitIntegerLiteral(ctx) {
    return ctx.text;
  }

  visitBooleanLiteral(ctx) {
    return ctx.text;
  }

  visitStringLiteral(ctx) {
    return ctx.text;
  }

  visitStatsAggTerm(ctx) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.visitStatsFunction(ctx.statsFunction()), ctx.wcFieldExpression() ? this.visitWcFieldExpression(ctx.wcFieldExpression()) : '');
  }

  visitWcFieldExpression(ctx) {
    // return only text from here to all its chilren for now
    return ctx.wcQualifiedName().text;
  }

  visitStatsByClause(ctx) {
    return new _expression.GroupBy('stats_by_clause', [], ctx.fieldList() ? this.visitFieldList(ctx.fieldList()) : [], ctx.bySpanClause() ? this.visitBySpanClause(ctx.bySpanClause()) : this.defaultResult());
  }

  visitBySpanClause(ctx) {
    return new _expression.Span('span_clause', [], this.visitSpanClause(ctx.spanClause()), ctx.qualifiedName() ? this.visitQualifiedName(ctx.qualifiedName()) : '');
  }

  visitSpanClause(ctx) {
    return new _expression.SpanExpression('span_expression', [], this.visitFieldExpression(ctx.fieldExpression()), this.visitLiteralValue(ctx.literalValue()), ctx.timespanUnit() ? this.visitTimespanUnit(ctx.timespanUnit()) : '');
  }

  visitLiteralValue(ctx) {
    return ctx.text;
  }

  visitTimespanUnit(ctx) {
    return ctx.text;
  }

  visitStatsFunction(ctx) {
    let funcName = '';
    let valueExpr = '';

    if ((0, _lodash.isFunction)(ctx.valueExpression)) {
      valueExpr = this.visitValueExpression(ctx.valueExpression());

      if ((0, _lodash.isFunction)(ctx.statsFunctionName)) {
        funcName = this.visitStatsFunctionName(ctx.statsFunctionName());
      } else {
        funcName = ctx.DISTINCT_COUNT() ? ctx.DISTINCT_COUNT().text : ctx.DC().text;
      }
    } else if ((0, _lodash.isFunction)(ctx.percentileAggFunction)) {// for now just return plain text
    } else if ((0, _lodash.isFunction)(ctx.COUNT)) {
      funcName = ctx.COUNT().text;
    }

    return new _expression.AggregateFunction('stats_function', [], funcName, valueExpr, (0, _lodash.isFunction)(ctx.percentileAggFunction) ? ctx.text : '');
  }

  visitValueExpression(ctx) {
    return ctx.text;
  }

  visitStatsFunctionName(ctx) {
    return ctx.text;
  }

  visitFieldList(ctx) {
    return ctx.fieldExpression().map(fieldExprAlternative => {
      return new _expression.Field('field_expression', [], this.visitFieldExpression(fieldExprAlternative));
    });
  }

  visitFieldExpression(ctx) {
    return this.visitQualifiedName(ctx.qualifiedName());
  }

  visitQualifiedName(ctx) {
    return ctx.text;
  }

}

exports.StatsAstBuilder = StatsAstBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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