"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WINDOW = exports.MILLIS_MULTIPLIER = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.DEFAULT_ROLLING_COUNTER = exports.COMPONENTS = exports.CAPACITY = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const WINDOW = 3600;
exports.WINDOW = WINDOW;
const INTERVAL = 60;
exports.INTERVAL = INTERVAL;
const CAPACITY = WINDOW / INTERVAL * 2;
exports.CAPACITY = CAPACITY;
const MILLIS_MULTIPLIER = 1000;
exports.MILLIS_MULTIPLIER = MILLIS_MULTIPLIER;
const commonRequests = ['create', 'get', 'update', 'delete', 'add_samples']; // object of each component and its specific requests

const COMPONENTS = {
  application_analytics: commonRequests,
  operational_panels: [...commonRequests, 'fetch_visualization'],
  event_analytics: commonRequests,
  notebooks: [...commonRequests, 'run_sql_query', 'run_ppl_query', 'fetch_visualization'],
  trace_analytics: commonRequests,
  metrics_analytics: commonRequests
};
exports.COMPONENTS = COMPONENTS;

const GLOBAL_BASIC_COUNTER = (() => {
  const counter = {};
  Object.entries(COMPONENTS).forEach(([component, requests]) => {
    requests.forEach(request => {
      _lodash.default.set(counter, [component, request, 'total'], 0);
    });
  });
  return counter;
})();

exports.GLOBAL_BASIC_COUNTER = GLOBAL_BASIC_COUNTER;

const DEFAULT_ROLLING_COUNTER = (() => {
  const counter = {};
  Object.entries(COMPONENTS).forEach(([component, requests]) => {
    requests.forEach(request => {
      _lodash.default.set(counter, [component, request, 'count'], 0);

      _lodash.default.set(counter, [component, request, 'system_error'], 0);

      _lodash.default.set(counter, [component, request, 'user_error'], 0);
    });
  });
  return counter;
})();

exports.DEFAULT_ROLLING_COUNTER = DEFAULT_ROLLING_COUNTER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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