"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRelevancePlugin = void 0;

var _routes = require("./routes");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SearchRelevancePlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('SearchRelevance: Setup');
    const router = core.http.createRouter();
    const opensearchSearchRelevanceClient = core.opensearch.legacy.createClient('opensearch_search_relevance'); // @ts-ignore

    core.http.registerRouteHandlerContext('search_relevance_plugin', (context, request) => {
      return {
        logger: this.logger,
        relevancyWorkbenchClient: opensearchSearchRelevanceClient
      };
    }); // Register server side APIs

    (0, _routes.defineRoutes)({
      router
    });
    return {};
  }

  start(core) {
    this.logger.debug('SearchRelevance: Started');
    return {};
  }

  stop() {}

}

exports.SearchRelevancePlugin = SearchRelevancePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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