/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(-2.0) => -2.0
 * round(-1.4285715) => -1.0
 * round(-0.85714287) => -1.0
 * round(-0.2857143) => -0.0
 * round(0.2857143) => 0.0
 * round(0.85714287) => 1.0
 * round(1.4285715) => 1.0
 * round(2.0) => 2.0
 */
#version 130

void main()
{
  float[distance(round(-2.0), -2.0) <= 2e-05 ? 1 : -1] array0;
  float[distance(round(-1.4285715), -1.0) <= 1e-05 ? 1 : -1] array1;
  float[distance(round(-0.85714287), -1.0) <= 1e-05 ? 1 : -1] array2;
  float[distance(round(-0.2857143), -0.0) <= 0.0 ? 1 : -1] array3;
  float[distance(round(0.2857143), 0.0) <= 0.0 ? 1 : -1] array4;
  float[distance(round(0.85714287), 1.0) <= 1e-05 ? 1 : -1] array5;
  float[distance(round(1.4285715), 1.0) <= 1e-05 ? 1 : -1] array6;
  float[distance(round(2.0), 2.0) <= 2e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
