/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(66u, 72u, 87u, 75u) & (~ 0u)) => uvec4(66u, 72u, 87u, 75u)
 * (uvec4(66u, 72u, 87u, 75u) & (~ 6u)) => uvec4(64u, 72u, 81u, 73u)
 * (uvec4(66u, 72u, 87u, 75u) & (~ 12u)) => uvec4(66u, 64u, 83u, 67u)
 * (uvec4(66u, 72u, 87u, 75u) & (~ 32u)) => uvec4(66u, 72u, 87u, 75u)
 * (uvec4(66u, 72u, 87u, 75u) & (~ 74u)) => uvec4(0u, 0u, 21u, 1u)
 * (uvec4(24u, 40u, 23u, 74u) & (~ 0u)) => uvec4(24u, 40u, 23u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) & (~ 6u)) => uvec4(24u, 40u, 17u, 72u)
 * (uvec4(24u, 40u, 23u, 74u) & (~ 12u)) => uvec4(16u, 32u, 19u, 66u)
 * (uvec4(24u, 40u, 23u, 74u) & (~ 32u)) => uvec4(24u, 8u, 23u, 74u)
 * (uvec4(24u, 40u, 23u, 74u) & (~ 74u)) => uvec4(16u, 32u, 21u, 0u)
 */
#version 150

void main()
{
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (~ 0u)), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array0;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (~ 6u)), uvec4(64u, 72u, 81u, 73u))) ? 1 : -1] array1;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (~ 12u)), uvec4(66u, 64u, 83u, 67u))) ? 1 : -1] array2;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (~ 32u)), uvec4(66u, 72u, 87u, 75u))) ? 1 : -1] array3;
  float[all(equal((uvec4(66u, 72u, 87u, 75u) & (~ 74u)), uvec4(0u, 0u, 21u, 1u))) ? 1 : -1] array4;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (~ 0u)), uvec4(24u, 40u, 23u, 74u))) ? 1 : -1] array5;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (~ 6u)), uvec4(24u, 40u, 17u, 72u))) ? 1 : -1] array6;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (~ 12u)), uvec4(16u, 32u, 19u, 66u))) ? 1 : -1] array7;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (~ 32u)), uvec4(24u, 8u, 23u, 74u))) ? 1 : -1] array8;
  float[all(equal((uvec4(24u, 40u, 23u, 74u) & (~ 74u)), uvec4(16u, 32u, 21u, 0u))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
