# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class ScraperTargetsService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """ScraperTargetsService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_scrapers_id(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_prepare(scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_scrapers_id_async(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_prepare(scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_scrapers_id_prepare(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_scrapers_id', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_scrapers_id_labels_id(self, scraper_target_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_labels_id(scraper_target_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_labels_id_with_http_info(self, scraper_target_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_labels_id_with_http_info(scraper_target_id, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_labels_id_prepare(scraper_target_id, label_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_scrapers_id_labels_id_async(self, scraper_target_id, label_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a label from a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str label_id: The label ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_labels_id_prepare(scraper_target_id, label_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels/{labelID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_scrapers_id_labels_id_prepare(self, scraper_target_id, label_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'label_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_scrapers_id_labels_id', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_labels_id`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in local_var_params or
                local_var_params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `delete_scrapers_id_labels_id`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501
        if 'label_id' in local_var_params:
            path_params['labelID'] = local_var_params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_scrapers_id_members_id(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_members_id(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_members_id_with_http_info(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_members_id_with_http_info(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_members_id_prepare(user_id, scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_scrapers_id_members_id_async(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove a member from a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of member to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_members_id_prepare(user_id, scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_scrapers_id_members_id_prepare(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_scrapers_id_members_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_scrapers_id_members_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_members_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def delete_scrapers_id_owners_id(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_owners_id(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, **kwargs)  # noqa: E501
            return data

    def delete_scrapers_id_owners_id_with_http_info(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scrapers_id_owners_id_with_http_info(user_id, scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_owners_id_prepare(user_id, scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_scrapers_id_owners_id_async(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Remove an owner from a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of owner to remove. (required)
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_scrapers_id_owners_id_prepare(user_id, scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_scrapers_id_owners_id_prepare(self, user_id, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_scrapers_id_owners_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_scrapers_id_owners_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `delete_scrapers_id_owners_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_scrapers(self, **kwargs):  # noqa: E501,D401,D403
        """List all scraper targets.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: Specifies the name of the scraper target.
        :param list[str] id: List of scraper target IDs to return. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: Specifies the organization ID of the scraper target.
        :param str org: Specifies the organization name of the scraper target.
        :return: ScraperTargetResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_scrapers_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List all scraper targets.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: Specifies the name of the scraper target.
        :param list[str] id: List of scraper target IDs to return. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: Specifies the organization ID of the scraper target.
        :param str org: Specifies the organization name of the scraper target.
        :return: ScraperTargetResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_prepare(**kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponses',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scrapers_async(self, **kwargs):  # noqa: E501,D401,D403
        """List all scraper targets.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param str name: Specifies the name of the scraper target.
        :param list[str] id: List of scraper target IDs to return. If both `id` and `owner` are specified, only `id` is used.
        :param str org_id: Specifies the organization ID of the scraper target.
        :param str org: Specifies the organization name of the scraper target.
        :return: ScraperTargetResponses
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_prepare(**kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponses',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scrapers_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'name', 'id', 'org_id', 'org']  # noqa: E501
        self._check_operation_params('get_scrapers', all_params, local_var_params)

        path_params = {}

        query_params = []
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501
        if 'org_id' in local_var_params:
            query_params.append(('orgID', local_var_params['org_id']))  # noqa: E501
        if 'org' in local_var_params:
            query_params.append(('org', local_var_params['org']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_scrapers_id(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_prepare(scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scrapers_id_async(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_prepare(scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scrapers_id_prepare(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_scrapers_id', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_scrapers_id_labels(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_labels(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_labels_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_labels_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_labels_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_labels_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_labels_prepare(scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scrapers_id_labels_async(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all labels for a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_labels_prepare(scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelsResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scrapers_id_labels_prepare(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_scrapers_id_labels', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_labels`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_scrapers_id_members(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_members(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_members_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_members_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_members_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_members_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_members_prepare(scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scrapers_id_members_async(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all users with member privileges for a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMembers
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_members_prepare(scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMembers',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scrapers_id_members_prepare(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_scrapers_id_members', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_members`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_scrapers_id_owners(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_owners(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scrapers_id_owners_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scrapers_id_owners_with_http_info(scraper_target_id, **kwargs)  # noqa: E501
            return data

    def get_scrapers_id_owners_with_http_info(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scrapers_id_owners_with_http_info(scraper_target_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_owners_prepare(scraper_target_id, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_scrapers_id_owners_async(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        """List all owners of a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwners
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_scrapers_id_owners_prepare(scraper_target_id, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwners',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_scrapers_id_owners_prepare(self, scraper_target_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_scrapers_id_owners', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `get_scrapers_id_owners`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_scrapers_id(self, scraper_target_id, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        """Update a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scrapers_id(scraper_target_id, scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param ScraperTargetRequest scraper_target_request: Scraper target update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_scrapers_id_with_http_info(scraper_target_id, scraper_target_request, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_scrapers_id_with_http_info(scraper_target_id, scraper_target_request, **kwargs)  # noqa: E501
            return data

    def patch_scrapers_id_with_http_info(self, scraper_target_id, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        """Update a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_scrapers_id_with_http_info(scraper_target_id, scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param ScraperTargetRequest scraper_target_request: Scraper target update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_scrapers_id_prepare(scraper_target_id, scraper_target_request, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_scrapers_id_async(self, scraper_target_id, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        """Update a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The identifier of the scraper target. (required)
        :param ScraperTargetRequest scraper_target_request: Scraper target update to apply (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_scrapers_id_prepare(scraper_target_id, scraper_target_request, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_scrapers_id_prepare(self, scraper_target_id, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'scraper_target_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_scrapers_id', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `patch_scrapers_id`")  # noqa: E501
        # verify the required parameter 'scraper_target_request' is set
        if ('scraper_target_request' not in local_var_params or
                local_var_params['scraper_target_request'] is None):
            raise ValueError("Missing the required parameter `scraper_target_request` when calling `patch_scrapers_id`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'scraper_target_request' in local_var_params:
            body_params = local_var_params['scraper_target_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_scrapers(self, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        """Create a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers(scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScraperTargetRequest scraper_target_request: Scraper target to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_with_http_info(scraper_target_request, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_with_http_info(scraper_target_request, **kwargs)  # noqa: E501
            return data

    def post_scrapers_with_http_info(self, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        """Create a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_with_http_info(scraper_target_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ScraperTargetRequest scraper_target_request: Scraper target to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_prepare(scraper_target_request, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_scrapers_async(self, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        """Create a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param ScraperTargetRequest scraper_target_request: Scraper target to create (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ScraperTargetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_prepare(scraper_target_request, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ScraperTargetResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_scrapers_prepare(self, scraper_target_request, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_request', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_scrapers', all_params, local_var_params)
        # verify the required parameter 'scraper_target_request' is set
        if ('scraper_target_request' not in local_var_params or
                local_var_params['scraper_target_request'] is None):
            raise ValueError("Missing the required parameter `scraper_target_request` when calling `post_scrapers`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'scraper_target_request' in local_var_params:
            body_params = local_var_params['scraper_target_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_scrapers_id_labels(self, scraper_target_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_labels(scraper_target_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_labels_with_http_info(scraper_target_id, label_mapping, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_labels_with_http_info(scraper_target_id, label_mapping, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_labels_with_http_info(self, scraper_target_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_labels_with_http_info(scraper_target_id, label_mapping, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_id_labels_prepare(scraper_target_id, label_mapping, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_scrapers_id_labels_async(self, scraper_target_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        """Add a label to a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param LabelMapping label_mapping: Label to add (required)
        :param str zap_trace_span: OpenTracing span context
        :return: LabelResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_id_labels_prepare(scraper_target_id, label_mapping, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='LabelResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_scrapers_id_labels_prepare(self, scraper_target_id, label_mapping, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'label_mapping', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_scrapers_id_labels', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_labels`")  # noqa: E501
        # verify the required parameter 'label_mapping' is set
        if ('label_mapping' not in local_var_params or
                local_var_params['label_mapping'] is None):
            raise ValueError("Missing the required parameter `label_mapping` when calling `post_scrapers_id_labels`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'label_mapping' in local_var_params:
            body_params = local_var_params['label_mapping']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_scrapers_id_members(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_members(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_members_with_http_info(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_members_with_http_info(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_id_members_prepare(scraper_target_id, add_resource_member_request_body, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_scrapers_id_members_async(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add a member to a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as member (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_id_members_prepare(scraper_target_id, add_resource_member_request_body, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/members', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceMember',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_scrapers_id_members_prepare(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_scrapers_id_members', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_members`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_scrapers_id_members`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_scrapers_id_owners(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_owners(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, **kwargs)  # noqa: E501
            return data

    def post_scrapers_id_owners_with_http_info(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a scraper target.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_scrapers_id_owners_with_http_info(scraper_target_id, add_resource_member_request_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_id_owners_prepare(scraper_target_id, add_resource_member_request_body, **kwargs)

        return self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_scrapers_id_owners_async(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        """Add an owner to a scraper target.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str scraper_target_id: The scraper target ID. (required)
        :param AddResourceMemberRequestBody add_resource_member_request_body: User to add as owner (required)
        :param str zap_trace_span: OpenTracing span context
        :return: ResourceOwner
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_scrapers_id_owners_prepare(scraper_target_id, add_resource_member_request_body, **kwargs)

        return await self.api_client.call_api(
            '/api/v2/scrapers/{scraperTargetID}/owners', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='ResourceOwner',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_scrapers_id_owners_prepare(self, scraper_target_id, add_resource_member_request_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['scraper_target_id', 'add_resource_member_request_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_scrapers_id_owners', all_params, local_var_params)
        # verify the required parameter 'scraper_target_id' is set
        if ('scraper_target_id' not in local_var_params or
                local_var_params['scraper_target_id'] is None):
            raise ValueError("Missing the required parameter `scraper_target_id` when calling `post_scrapers_id_owners`")  # noqa: E501
        # verify the required parameter 'add_resource_member_request_body' is set
        if ('add_resource_member_request_body' not in local_var_params or
                local_var_params['add_resource_member_request_body'] is None):
            raise ValueError("Missing the required parameter `add_resource_member_request_body` when calling `post_scrapers_id_owners`")  # noqa: E501

        path_params = {}
        if 'scraper_target_id' in local_var_params:
            path_params['scraperTargetID'] = local_var_params['scraper_target_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'add_resource_member_request_body' in local_var_params:
            body_params = local_var_params['add_resource_member_request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
