/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.util.function.Supplier;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.clustering.ClusteringComponent;
import org.apache.solr.handler.clustering.Engine;
import org.apache.solr.handler.clustering.EngineParameters;
import org.apache.solr.schema.SchemaField;

final class EngineEntry
implements Supplier<Engine> {
    private static final String PARAM_OPTIONAL = "optional";
    private static final String PARAM_NAME = "name";
    final boolean optional;
    final String engineName;
    final EngineParameters defaults;
    private Engine engine;
    private boolean available;

    EngineEntry(SolrParams params) {
        this.optional = params.getBool(PARAM_OPTIONAL, false);
        this.engineName = params.get(PARAM_NAME, "");
        this.defaults = new EngineParameters(params);
    }

    boolean initialize(SolrCore core) {
        SchemaField uniqueField = core.getLatestSchema().getUniqueKeyField();
        if (uniqueField == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, ClusteringComponent.class.getSimpleName() + " requires the declaration of uniqueKeyField in the schema.");
        }
        String docIdField = uniqueField.getName();
        this.defaults.setDocIdField(docIdField);
        this.engine = new Engine();
        this.available = this.engine.init(this.engineName, core, this.defaults);
        return this.available;
    }

    @Override
    public Engine get() {
        return this.engine;
    }
}

