/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.memory.FSTTermOutputs;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

public class FSTTermsWriter
extends FieldsConsumer {
    static final String TERMS_EXTENSION = "tfp";
    static final String TERMS_CODEC_NAME = "FSTTerms";
    public static final int TERMS_VERSION_START = 2;
    public static final int TERMS_VERSION_CURRENT = 2;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    IndexOutput out;
    final int maxDoc;
    final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSTTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter) throws IOException {
        String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
        this.postingsWriter = postingsWriter;
        this.fieldInfos = state.fieldInfos;
        this.out = state.directory.createOutput(termsFileName, state.context);
        this.maxDoc = state.segmentInfo.maxDoc();
        boolean success = false;
        try {
            CodecUtil.writeIndexHeader((DataOutput)this.out, (String)TERMS_CODEC_NAME, (int)2, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            this.postingsWriter.init(this.out, state);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    private void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    public void write(Fields fields, NormsProducer norms) throws IOException {
        for (String field : fields) {
            BytesRef term;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
            boolean hasFreq = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(fieldInfo);
            long sumTotalTermFreq = 0L;
            long sumDocFreq = 0L;
            FixedBitSet docsSeen = new FixedBitSet(this.maxDoc);
            while ((term = termsEnum.next()) != null) {
                BlockTermState termState = this.postingsWriter.writeTerm(term, termsEnum, docsSeen, norms);
                if (termState == null) continue;
                termsWriter.finishTerm(term, termState);
                sumTotalTermFreq += termState.totalTermFreq;
                sumDocFreq += (long)termState.docFreq;
            }
            termsWriter.finish(hasFreq ? sumTotalTermFreq : -1L, sumDocFreq, docsSeen.cardinality());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            block8: {
                block6: {
                    if (this.out == null) break block7;
                    boolean success = false;
                    try {
                        long dirStart = this.out.getFilePointer();
                        this.out.writeVInt(this.fields.size());
                        for (FieldMetaData field : this.fields) {
                            this.out.writeVInt(field.fieldInfo.number);
                            this.out.writeVLong(field.numTerms);
                            if (field.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                                this.out.writeVLong(field.sumTotalTermFreq);
                            }
                            this.out.writeVLong(field.sumDocFreq);
                            this.out.writeVInt(field.docCount);
                            field.dict.save((DataOutput)this.out, (DataOutput)this.out);
                        }
                        this.writeTrailer(this.out, dirStart);
                        CodecUtil.writeFooter((IndexOutput)this.out);
                        success = true;
                        if (!success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.postingsWriter});
                        }
                        this.out = null;
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{this.out, this.postingsWriter});
                    break block8;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out, this.postingsWriter});
            }
            this.out = null;
        }
    }

    final class TermsWriter {
        private final FSTCompiler<FSTTermOutputs.TermData> fstCompiler;
        private final FSTTermOutputs outputs;
        private final FieldInfo fieldInfo;
        private long numTerms = 0L;
        private final IntsRefBuilder scratchTerm = new IntsRefBuilder();
        private final ByteBuffersDataOutput metaWriter = ByteBuffersDataOutput.newResettableInstance();

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            FSTTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.outputs = new FSTTermOutputs(fieldInfo);
            this.fstCompiler = new FSTCompiler(FST.INPUT_TYPE.BYTE1, (Outputs)this.outputs);
        }

        public void finishTerm(BytesRef text, BlockTermState state) throws IOException {
            FSTTermOutputs.TermData meta = new FSTTermOutputs.TermData();
            meta.bytes = null;
            meta.docFreq = state.docFreq;
            meta.totalTermFreq = state.totalTermFreq;
            FSTTermsWriter.this.postingsWriter.encodeTerm((DataOutput)this.metaWriter, this.fieldInfo, state, true);
            if (this.metaWriter.size() > 0L) {
                meta.bytes = this.metaWriter.toArrayCopy();
                this.metaWriter.reset();
            }
            this.fstCompiler.add(Util.toIntsRef((BytesRef)text, (IntsRefBuilder)this.scratchTerm), (Object)meta);
            ++this.numTerms;
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            if (this.numTerms > 0L) {
                FST fst = this.fstCompiler.compile();
                FSTTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, this.numTerms, sumTotalTermFreq, sumDocFreq, docCount, (FST<FSTTermOutputs.TermData>)fst));
            }
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final long numTerms;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        public final FST<FSTTermOutputs.TermData> dict;

        public FieldMetaData(FieldInfo fieldInfo, long numTerms, long sumTotalTermFreq, long sumDocFreq, int docCount, FST<FSTTermOutputs.TermData> fst) {
            this.fieldInfo = fieldInfo;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.dict = fst;
        }
    }
}

