/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.CreateCorePayload;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/cores"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.CORE_EDIT_PERM)
public class CreateCoreAPI {
    public static final String V2_CREATE_CORE_CMD = "create";
    private final CoreAdminHandler coreAdminHandler;

    public CreateCoreAPI(CoreAdminHandler coreAdminHandler) {
        this.coreAdminHandler = coreAdminHandler;
    }

    @Command(name="create")
    public void createCore(PayloadObj<CreateCorePayload> obj) throws Exception {
        CreateCorePayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CoreAdminParams.CoreAdminAction.CREATE.name().toLowerCase(Locale.ROOT));
        if (v2Body.isTransient != null) {
            v1Params.put("transient", v1Params.remove("isTransient"));
        }
        if (v2Body.properties != null) {
            v1Params.remove("properties");
            V2ApiUtils.flattenMapWithPrefix(v2Body.properties, v1Params, "property.");
        }
        if (v2Body.roles != null && !v2Body.roles.isEmpty()) {
            v1Params.remove("roles");
            V2ApiUtils.flattenToCommaDelimitedString(v1Params, v2Body.roles, "roles");
        }
        this.coreAdminHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

