/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Lists;
import net.thisptr.jackson.jq.internal.misc.Preconditions;

@BuiltinFunction(value={"keys/0"})
public class KeysFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("keys", in, JsonNodeType.OBJECT, JsonNodeType.ARRAY);
        if (in.isObject()) {
            List<String> keys = Lists.newArrayList(in.fieldNames());
            Collections.sort(keys);
            ArrayNode result = scope.getObjectMapper().createArrayNode();
            for (String key : keys) {
                result.add((JsonNode)new TextNode(key));
            }
            return Collections.singletonList(result);
        }
        if (in.isArray()) {
            ArrayNode result = scope.getObjectMapper().createArrayNode();
            for (int i = 0; i < in.size(); ++i) {
                result.add((JsonNode)new IntNode(i));
            }
            return Collections.singletonList(result);
        }
        throw new IllegalStateException();
    }
}

