/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeMovingAddressesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private ListWithAutoConstructFlag<String> publicIps;
    private String nextToken;
    private ListWithAutoConstructFlag<Filter> filters;
    private Integer maxResults;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DescribeMovingAddressesRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getPublicIps() {
        if (this.publicIps == null) {
            this.publicIps = new ListWithAutoConstructFlag();
            this.publicIps.setAutoConstruct(true);
        }
        return this.publicIps;
    }

    public void setPublicIps(Collection<String> publicIps) {
        if (publicIps == null) {
            this.publicIps = null;
            return;
        }
        ListWithAutoConstructFlag publicIpsCopy = new ListWithAutoConstructFlag(publicIps.size());
        publicIpsCopy.addAll(publicIps);
        this.publicIps = publicIpsCopy;
    }

    public DescribeMovingAddressesRequest withPublicIps(String ... publicIps) {
        if (this.getPublicIps() == null) {
            this.setPublicIps(new ArrayList<String>(publicIps.length));
        }
        for (String value : publicIps) {
            this.getPublicIps().add(value);
        }
        return this;
    }

    public DescribeMovingAddressesRequest withPublicIps(Collection<String> publicIps) {
        if (publicIps == null) {
            this.publicIps = null;
        } else {
            ListWithAutoConstructFlag publicIpsCopy = new ListWithAutoConstructFlag(publicIps.size());
            publicIpsCopy.addAll(publicIps);
            this.publicIps = publicIpsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeMovingAddressesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeMovingAddressesRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeMovingAddressesRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeMovingAddressesRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getPublicIps() != null) {
            sb.append("PublicIps: " + this.getPublicIps() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIps() == null ? 0 : ((Object)this.getPublicIps()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMovingAddressesRequest)) {
            return false;
        }
        DescribeMovingAddressesRequest other = (DescribeMovingAddressesRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getPublicIps() == null ^ this.getPublicIps() == null) {
            return false;
        }
        if (other.getPublicIps() != null && !((Object)other.getPublicIps()).equals(this.getPublicIps())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !((Object)other.getFilters()).equals(this.getFilters())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }
}

