/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.AssociationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.LaunchDesc;
import net.sourceforge.jnlp.MenuDesc;
import net.sourceforge.jnlp.MissingInformationException;
import net.sourceforge.jnlp.MissingTitleException;
import net.sourceforge.jnlp.MissingVendorException;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.RelatedContentDesc;
import net.sourceforge.jnlp.RequiredElementException;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.UpdateDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class Parser {
    private static String CODEBASE = "codebase";
    private static String MAINCLASS = "main-class";
    private static final Pattern anyWhiteSpace = Pattern.compile("\\s");
    private final JNLPFile file;
    private final Node root;
    private final Version spec;
    private final URL base;
    private URL codebase;
    private final URL fileLocation;
    private final boolean strict;
    private final boolean allowExtensions;
    public static final String MALFORMED_PARSER_CLASS = "net.sourceforge.jnlp.MalformedXMLParser";
    public static final String NORMAL_PARSER_CLASS = "net.sourceforge.jnlp.XMLParser";

    Parser(JNLPFile file, URL base, Node root, ParserSettings settings) throws ParseException {
        this(file, base, root, settings, null);
    }

    Parser(JNLPFile file, URL base, Node root, ParserSettings settings, URL codebase) throws ParseException {
        this.file = file;
        this.root = root;
        this.strict = settings.isStrict();
        this.allowExtensions = settings.isExtensionAllowed();
        if (root == null || !root.getNodeName().equals("jnlp")) {
            throw new ParseException(Translator.R("PInvalidRoot"));
        }
        this.spec = this.getVersion(root, "spec", "1.0+");
        try {
            this.codebase = this.addSlash(this.getURL(root, CODEBASE, base));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.codebase == null) {
            this.codebase = codebase;
        }
        this.base = this.codebase != null ? this.codebase : base;
        this.fileLocation = this.getURL(root, "href", this.base);
        root.normalize();
    }

    public Version getFileVersion() {
        return this.getVersion(this.root, "version", null);
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public Version getSpecVersion() {
        return this.spec;
    }

    UpdateDesc getUpdate(Node parent) throws ParseException {
        UpdateDesc updateDesc = null;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            UpdateDesc.Policy policy;
            String policyString;
            UpdateDesc.Check check;
            String checkValue;
            if (!child.getNodeName().equals("update")) continue;
            if (this.strict && updateDesc != null) {
                throw new ParseException(Translator.R("PTwoUpdates"));
            }
            Node node = child;
            switch (checkValue = this.getAttribute(node, "check", "timeout")) {
                case "always": {
                    check = UpdateDesc.Check.ALWAYS;
                    break;
                }
                case "timeout": {
                    check = UpdateDesc.Check.TIMEOUT;
                    break;
                }
                case "background": {
                    check = UpdateDesc.Check.BACKGROUND;
                    break;
                }
                default: {
                    check = UpdateDesc.Check.TIMEOUT;
                }
            }
            switch (policyString = this.getAttribute(node, "policy", "always")) {
                case "always": {
                    policy = UpdateDesc.Policy.ALWAYS;
                    break;
                }
                case "prompt-update": {
                    policy = UpdateDesc.Policy.PROMPT_UPDATE;
                    break;
                }
                case "prompt-run": {
                    policy = UpdateDesc.Policy.PROMPT_RUN;
                    break;
                }
                default: {
                    policy = UpdateDesc.Policy.ALWAYS;
                }
            }
            updateDesc = new UpdateDesc(check, policy);
        }
        if (updateDesc == null) {
            updateDesc = new UpdateDesc(UpdateDesc.Check.TIMEOUT, UpdateDesc.Policy.ALWAYS);
        }
        return updateDesc;
    }

    List<ResourcesDesc> getResources(Node parent, boolean j2se) throws ParseException {
        ArrayList<ResourcesDesc> result = new ArrayList<ResourcesDesc>();
        Node[] resources = Parser.getChildNodes(parent, "resources");
        if (resources.length == 0 && !j2se) {
            throw new ParseException(Translator.R("PNoResources"));
        }
        for (Node resource : resources) {
            result.add(this.getResourcesDesc(resource, j2se));
        }
        return result;
    }

    private ResourcesDesc getResourcesDesc(Node node, boolean j2se) throws ParseException {
        boolean mainFlag = false;
        ResourcesDesc resources = new ResourcesDesc(this.file, this.getLocales(node), this.splitString(this.getAttribute(node, "os", null)), this.splitString(this.getAttribute(node, "arch", null)));
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("nativelib".equals(name) && !this.isTrustedEnvironment()) {
                throw new ParseException(Translator.R("PUntrustedNative"));
            }
            if ("j2se".equals(name) || "java".equals(name)) {
                if (Parser.getChildNode(this.root, "component-desc") != null && this.strict) {
                    throw new ParseException(Translator.R("PExtensionHasJ2SE"));
                }
                if (!j2se) {
                    resources.addResource(this.getJRE(child));
                } else {
                    throw new ParseException(Translator.R("PInnerJ2SE"));
                }
            }
            if ("jar".equals(name) || "nativelib".equals(name)) {
                JARDesc jar = this.getJAR(child);
                if (jar.isMain()) {
                    if (mainFlag && this.strict) {
                        throw new ParseException(Translator.R("PTwoMains"));
                    }
                    mainFlag = true;
                }
                resources.addResource(jar);
            }
            if ("extension".equals(name)) {
                resources.addResource(this.getExtension(child));
            }
            if ("property".equals(name)) {
                resources.addResource(this.getProperty(child));
            }
            if (!"package".equals(name)) continue;
            resources.addResource(this.getPackage(child));
        }
        return resources;
    }

    private JREDesc getJRE(Node node) throws ParseException {
        Version version = this.getVersion(node, "version", null);
        URL location = this.getURL(node, "href", this.base);
        String vmArgs = this.getAttribute(node, "java-vm-args", null);
        try {
            this.checkVMArgs(vmArgs);
        }
        catch (IllegalArgumentException argumentException) {
            vmArgs = null;
        }
        String initialHeap = this.getAttribute(node, "initial-heap-size", null);
        String maxHeap = this.getAttribute(node, "max-heap-size", null);
        List<ResourcesDesc> resources = this.getResources(node, true);
        this.getRequiredAttribute(node, "version", null);
        return new JREDesc(new Version.JreVersion(version.toString(), this.strict), location, vmArgs, initialHeap, maxHeap, resources);
    }

    private JARDesc getJAR(Node node) throws ParseException {
        boolean nativeJar = "nativelib".equals(node.getNodeName());
        URL location = this.getRequiredURL(node, "href", this.base);
        Version version = this.getVersion(node, "version", null);
        String part = this.getAttribute(node, "part", null);
        boolean main = "true".equals(this.getAttribute(node, "main", "false"));
        boolean lazy = "lazy".equals(this.getAttribute(node, "download", "eager"));
        if (nativeJar && main && this.strict) {
            throw new ParseException(Translator.R("PNativeHasMain"));
        }
        return new JARDesc(location, version, part, lazy, main, nativeJar, true);
    }

    private ExtensionDesc getExtension(Node node) throws ParseException {
        Node[] dload;
        String name = this.getAttribute(node, "name", null);
        Version version = this.getVersion(node, "version", null);
        URL location = this.getRequiredURL(node, "href", this.base);
        ExtensionDesc ext = new ExtensionDesc(name, version, location);
        for (Node dload1 : dload = Parser.getChildNodes(node, "ext-download")) {
            boolean lazy = "lazy".equals(this.getAttribute(dload1, "download", "eager"));
            ext.addPart(this.getRequiredAttribute(dload1, "ext-part", null), this.getAttribute(dload1, "part", null), lazy);
        }
        return ext;
    }

    private PropertyDesc getProperty(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", null);
        String value = this.getRequiredAttribute(node, "value", "");
        return new PropertyDesc(name, value);
    }

    private PackageDesc getPackage(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", null);
        String part = this.getRequiredAttribute(node, "part", "");
        boolean recursive = this.getAttribute(node, "recursive", "false").equals("true");
        return new PackageDesc(name, part, recursive);
    }

    void checkForInformation() throws RequiredElementException {
        OutputController.getLogger().log("Homepage: " + this.file.getInformation().getHomepage());
        OutputController.getLogger().log("Description: " + this.file.getInformation().getDescription());
        String title = this.file.getTitle();
        String vendor = this.file.getVendor();
        if (title == null || title.trim().isEmpty()) {
            throw new MissingTitleException();
        }
        OutputController.getLogger().log("Acceptable title tag found, contains: " + title);
        if (vendor == null || vendor.trim().isEmpty()) {
            throw new MissingVendorException();
        }
        OutputController.getLogger().log("Acceptable vendor tag found, contains: " + vendor);
    }

    List<InformationDesc> getInfo(Node parent) throws ParseException {
        ArrayList<InformationDesc> result = new ArrayList<InformationDesc>();
        Node[] info = Parser.getChildNodes(parent, "information");
        if (info.length == 0) {
            throw new MissingInformationException();
        }
        for (Node infoNode : info) {
            result.add(this.getInformationDesc(infoNode));
        }
        return result;
    }

    InformationDesc getInformationDesc(Node node) throws ParseException {
        ArrayList<String> descriptionsUsed = new ArrayList<String>();
        Locale[] locales = this.getLocales(node);
        InformationDesc info = new InformationDesc(locales, this.strict);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("title".equals(name)) {
                this.addInfo(info, child, null, this.getSpanText(child, false));
            }
            if ("vendor".equals(name)) {
                this.addInfo(info, child, null, this.getSpanText(child, false));
            }
            if ("description".equals(name)) {
                String kind = this.getAttribute(child, "kind", "default");
                if (descriptionsUsed.contains(kind) && this.strict) {
                    throw new ParseException(Translator.R("PTwoDescriptions", kind));
                }
                descriptionsUsed.add(kind);
                this.addInfo(info, child, kind, this.getSpanText(child, false));
            }
            if ("homepage".equals(name)) {
                this.addInfo(info, child, null, this.getRequiredURL(child, "href", this.base));
            }
            if ("icon".equals(name)) {
                this.addInfo(info, child, this.getAttribute(child, "kind", "default"), this.getIcon(child));
            }
            if ("offline-allowed".equals(name)) {
                this.addInfo(info, child, null, Boolean.TRUE);
            }
            if ("sharing-allowed".equals(name)) {
                if (this.strict && !this.allowExtensions) {
                    throw new ParseException(Translator.R("PSharing"));
                }
                this.addInfo(info, child, null, Boolean.TRUE);
            }
            if ("association".equals(name)) {
                this.addInfo(info, child, null, this.getAssociation(child));
            }
            if ("shortcut".equals(name)) {
                this.addInfo(info, child, null, this.getShortcut(child));
            }
            if (!"related-content".equals(name)) continue;
            this.addInfo(info, child, null, this.getRelatedContent(child));
        }
        return info;
    }

    protected void addInfo(InformationDesc info, Node node, String mod, Object value) {
        String modStr;
        String string = modStr = mod == null ? "" : "-" + mod;
        if (node == null) {
            return;
        }
        info.addItem(node.getNodeName() + modStr, value);
    }

    private IconDesc getIcon(Node node) throws ParseException {
        int width = Integer.parseInt(this.getAttribute(node, "width", "-1"));
        int height = Integer.parseInt(this.getAttribute(node, "height", "-1"));
        int size = Integer.parseInt(this.getAttribute(node, "size", "-1"));
        int depth = Integer.parseInt(this.getAttribute(node, "depth", "-1"));
        URL location = this.getRequiredURL(node, "href", this.base);
        String kind = this.getAttribute(node, "kind", "default");
        return new IconDesc(location, kind, width, height, depth, size);
    }

    SecurityDesc getSecurity(Node parent) throws ParseException {
        Node[] nodes = Parser.getChildNodes(parent, "security");
        if (nodes.length > 1 && this.strict) {
            throw new ParseException(Translator.R("PTwoSecurity"));
        }
        Object type = SecurityDesc.SANDBOX_PERMISSIONS;
        SecurityDesc.RequestedPermissionLevel requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.NONE;
        if (nodes.length == 0) {
            type = SecurityDesc.SANDBOX_PERMISSIONS;
            requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.NONE;
        } else if (null != Parser.getChildNode(nodes[0], "all-permissions")) {
            type = SecurityDesc.ALL_PERMISSIONS;
            requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.ALL;
        } else if (null != Parser.getChildNode(nodes[0], "j2ee-application-client-permissions")) {
            type = SecurityDesc.J2EE_PERMISSIONS;
            requestedPermissionLevel = SecurityDesc.RequestedPermissionLevel.J2EE;
        } else if (this.strict) {
            throw new ParseException(Translator.R("PEmptySecurity"));
        }
        if (this.base != null) {
            return new SecurityDesc(this.file, requestedPermissionLevel, type, this.base);
        }
        return new SecurityDesc(this.file, requestedPermissionLevel, type, null);
    }

    private boolean isTrustedEnvironment() {
        Node security = Parser.getChildNode(this.root, "security");
        return security != null && (Parser.getChildNode(security, "all-permissions") != null || Parser.getChildNode(security, "j2ee-application-client-permissions") != null);
    }

    LaunchDesc getLauncher(Node parent) throws ParseException {
        if (1 < Parser.getChildNodes(parent, "applet-desc").length + Parser.getChildNodes(parent, "application-desc").length + Parser.getChildNodes(parent, "installer-desc").length) {
            throw new ParseException(Translator.R("PTwoDescriptors"));
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("applet-desc".equals(name)) {
                return this.getApplet(child);
            }
            if ("application-desc".equals(name)) {
                return this.getApplication(child);
            }
            if (!"installer-desc".equals(name)) continue;
            return this.getInstaller(child);
        }
        return null;
    }

    private AppletDesc getApplet(Node node) throws ParseException {
        Node[] params;
        String name = this.getRequiredAttribute(node, "name", Translator.R("PUnknownApplet"));
        String main = this.getMainClass(node, true);
        URL docbase = this.getURL(node, "documentbase", this.base);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int width = 0;
        int height = 0;
        try {
            width = Integer.parseInt(this.getRequiredAttribute(node, "width", "100"));
            height = Integer.parseInt(this.getRequiredAttribute(node, "height", "100"));
        }
        catch (NumberFormatException nfe) {
            if (width <= 0) {
                throw new ParseException(Translator.R("PBadWidth"));
            }
            throw new ParseException(Translator.R("PBadWidth"));
        }
        for (Node param : params = Parser.getChildNodes(node, "param")) {
            paramMap.put(this.getRequiredAttribute(param, "name", null), this.getRequiredAttribute(param, "value", ""));
        }
        return new AppletDesc(name, main, docbase, width, height, paramMap);
    }

    private ApplicationDesc getApplication(Node node) throws ParseException {
        Node[] args;
        String main = this.getMainClass(node, false);
        ArrayList<String> argsList = new ArrayList<String>();
        for (Node arg : args = Parser.getChildNodes(node, "argument")) {
            argsList.add(this.getSpanText(arg));
        }
        String[] argStrings = argsList.toArray(new String[argsList.size()]);
        return new ApplicationDesc(main, argStrings);
    }

    ComponentDesc getComponent(Node parent) throws ParseException {
        if (1 < Parser.getChildNodes(parent, "component-desc").length) {
            throw new ParseException(Translator.R("PTwoDescriptors"));
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (!"component-desc".equals(name)) continue;
            return new ComponentDesc();
        }
        return null;
    }

    private InstallerDesc getInstaller(Node node) {
        String main = this.getOptionalMainClass(node);
        return new InstallerDesc(main);
    }

    private AssociationDesc getAssociation(Node node) throws ParseException {
        String[] extensions = this.getRequiredAttribute(node, "extensions", null).split(" ");
        String mimeType = this.getRequiredAttribute(node, "mime-type", null);
        return new AssociationDesc(mimeType, extensions);
    }

    private ShortcutDesc getShortcut(Node node) throws ParseException {
        String online = this.getAttribute(node, "online", "true");
        boolean shortcutIsOnline = Boolean.valueOf(online);
        boolean showOnDesktop = false;
        MenuDesc menu = null;
        block8: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (null == name) continue;
            switch (name) {
                case "desktop": {
                    if (showOnDesktop && this.strict) {
                        throw new ParseException(Translator.R("PTwoDesktops"));
                    }
                    showOnDesktop = true;
                    continue block8;
                }
                case "menu": {
                    if (menu != null && this.strict) {
                        throw new ParseException(Translator.R("PTwoMenus"));
                    }
                    menu = this.getMenu(child);
                }
            }
        }
        ShortcutDesc shortcut = new ShortcutDesc(shortcutIsOnline, showOnDesktop);
        if (menu != null) {
            shortcut.setMenu(menu);
        }
        return shortcut;
    }

    private MenuDesc getMenu(Node node) {
        String subMenu = this.getAttribute(node, "submenu", null);
        return new MenuDesc(subMenu);
    }

    private RelatedContentDesc getRelatedContent(Node node) throws ParseException {
        this.getRequiredAttribute(node, "href", null);
        URL location = this.getURL(node, "href", this.base);
        String title = null;
        String description = null;
        IconDesc icon = null;
        block10: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if (null == name) continue;
            switch (name) {
                case "title": {
                    if (title != null && this.strict) {
                        throw new ParseException(Translator.R("PTwoTitles"));
                    }
                    title = this.getSpanText(child, false);
                    continue block10;
                }
                case "description": {
                    if (description != null && this.strict) {
                        throw new ParseException(Translator.R("PTwoDescriptions"));
                    }
                    description = this.getSpanText(child, false);
                    continue block10;
                }
                case "icon": {
                    if (icon != null && this.strict) {
                        throw new ParseException(Translator.R("PTwoIcons"));
                    }
                    icon = this.getIcon(child);
                }
            }
        }
        RelatedContentDesc relatedContent = new RelatedContentDesc(location);
        relatedContent.setDescription(description);
        relatedContent.setIconDesc(icon);
        relatedContent.setTitle(title);
        return relatedContent;
    }

    private String[] splitString(String source) {
        if (source == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(source, " ");
        StringBuilder part = new StringBuilder();
        while (st.hasMoreTokens()) {
            part.setLength(0);
            while (true) {
                part.append(st.nextToken());
                if (!st.hasMoreTokens() || part.charAt(part.length() - 1) != '\\') break;
                part.setCharAt(part.length() - 1, ' ');
            }
            int i = part.length();
            while (i-- > 0) {
                if (part.charAt(i) != '\\') continue;
                part.deleteCharAt(i--);
            }
            result.add(part.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    private Locale[] getLocales(Node node) {
        String[] localeParts;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String localePart : localeParts = this.splitString(this.getAttribute(node, "locale", ""))) {
            Locale l = this.getLocale(localePart);
            if (l == null) continue;
            locales.add(l);
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    public Locale getLocale(String localeStr) {
        if (localeStr.length() < 2) {
            return null;
        }
        String language = localeStr.substring(0, 2);
        String country = localeStr.length() < 5 ? "" : localeStr.substring(3, 5);
        String variant = localeStr.length() > 7 ? localeStr.substring(6) : "";
        return new Locale(language, country, variant);
    }

    private String getSpanText(Node node) throws ParseException {
        return this.getSpanText(node, true);
    }

    private String getSpanText(Node node, boolean preserveSpacing) throws ParseException {
        if (node == null) {
            return null;
        }
        String val = node.getNodeValue();
        if (preserveSpacing) {
            return val;
        }
        if (val == null) {
            return null;
        }
        return val.replaceAll("\\s+", " ");
    }

    private static Node getChildNode(Node node, String name) {
        Node[] result = Parser.getChildNodes(node, name);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    private static Node[] getChildNodes(Node node, String name) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new Node[result.size()]);
    }

    private URL addSlash(URL source) {
        if (source == null) {
            return null;
        }
        if (!source.toString().endsWith("/")) {
            try {
                source = new URL(source.toString() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return source;
    }

    private URL getRequiredURL(Node node, String name, URL base) throws ParseException {
        this.getRequiredAttribute(node, name, "");
        return this.getURL(node, name, base);
    }

    URL getURL(Node node, String name, URL base) throws ParseException {
        String href;
        if (CODEBASE.equals(name)) {
            href = this.getCleanAttribute(node, name);
            if (href != null && href.trim().isEmpty()) {
                href = ".";
            }
        } else {
            href = this.getAttribute(node, name, null);
        }
        return Parser.getURL(href, node.getNodeName(), base, this.strict);
    }

    /*
     * Loose catch block
     */
    public static URL getURL(String href, String nodeName, URL base, boolean strict) throws ParseException {
        block8: {
            if (href == null) {
                return null;
            }
            if (base != null) break block8;
            return new URL(href);
            {
                catch (MalformedURLException ex) {
                    if (base == null) {
                        throw new ParseException(Translator.R("PBadNonrelativeUrl", nodeName, href));
                    }
                    throw new ParseException(Translator.R("PBadRelativeUrl", nodeName, href, base));
                }
            }
        }
        try {
            return new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            URL result = new URL(base, href);
            if (!result.toString().startsWith(base.toString()) && !base.toString().startsWith(result.toString()) && strict) {
                throw new ParseException(Translator.R("PUrlNotInCodebase", nodeName, href, base));
            }
            return result;
        }
    }

    private Version getVersion(Node node, String name, String defaultValue) {
        String version = this.getAttribute(node, name, defaultValue);
        if (version == null) {
            return null;
        }
        return new Version(version);
    }

    private void checkVMArgs(String vmArgs) throws IllegalArgumentException {
        String[] arguments;
        if (vmArgs == null) {
            return;
        }
        List<String> validArguments = Arrays.asList(this.getValidVMArguments());
        List<String> validStartingArguments = Arrays.asList(this.getValidStartingVMArguments());
        for (String argument : arguments = vmArgs.split(" ")) {
            boolean argumentIsValid = false;
            if (validArguments.contains(argument)) {
                argumentIsValid = true;
            } else {
                for (String validStartingArgument : validStartingArguments) {
                    if (!argument.startsWith(validStartingArgument)) continue;
                    argumentIsValid = true;
                    break;
                }
            }
            if (argumentIsValid) continue;
            throw new IllegalArgumentException(argument);
        }
    }

    private String[] getValidVMArguments() {
        return new String[]{"-d32", "-client", "-server", "-verbose", "-version", "-showversion", "-help", "-X", "-ea", "-enableassertions", "-da", "-disableassertions", "-esa", "-enablesystemassertions", "-dsa", "-disablesystemassertions", "-Xmixed", "-Xint", "-Xnoclassgc", "-Xincgc", "-Xbatch", "-Xprof", "-Xdebug", "-Xfuture", "-Xrs", "-XX:+ForceTimeHighResolution", "-XX:-ForceTimeHighResolution"};
    }

    private String[] getValidStartingVMArguments() {
        return new String[]{"-ea", "-enableassertions", "-da", "-disableassertions", "-verbose", "-Xms", "-Xmx", "-Xss", "-XX:NewRatio", "-XX:NewSize", "-XX:MaxNewSize", "-XX:PermSize", "-XX:MaxPermSize", "-XX:MaxHeapFreeRatio", "-XX:MinHeapFreeRatio", "-XX:UseSerialGC", "-XX:ThreadStackSize", "-XX:MaxInlineSize", "-XX:ReservedCodeCacheSize", "-XX:MaxDirectMemorySize"};
    }

    private String getRequiredAttribute(Node node, String name, String defaultValue) throws ParseException {
        String result = this.getAttribute(node, name, null);
        if (!(result != null && result.length() != 0 || !this.strict && defaultValue != null)) {
            throw new ParseException(Translator.R("PNeedsAttribute", node.getNodeName(), name));
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private String getAttribute(Node node, String name, String defaultValue) {
        String result = this.getCleanAttribute(node, name);
        if (result == null || result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    private String getCleanAttribute(Node node, String name) {
        String result = node.getAttribute(name);
        return result;
    }

    static Node getRootNode(InputStream input, ParserSettings settings) throws ParseException {
        try {
            Object parser = Parser.getParserInstance(settings);
            Method m = parser.getClass().getMethod("getRootNode", InputStream.class);
            return (Node)m.invoke(parser, input);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ParseException) {
                throw (ParseException)e.getCause();
            }
            throw new ParseException(Translator.R("PBadXML"), e);
        }
        catch (Exception e) {
            throw new ParseException(Translator.R("PBadXML"), e);
        }
    }

    public static Object getParserInstance(ParserSettings settings) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Object instance;
        String className;
        if (settings.isMalformedXmlAllowed()) {
            className = MALFORMED_PARSER_CLASS;
            ParseException.setExpected(ParseException.UsedParsers.MALFORMED);
        } else {
            className = NORMAL_PARSER_CLASS;
            ParseException.setExpected(ParseException.UsedParsers.NORMAL);
        }
        try {
            Class<?> klass = Class.forName(className);
            instance = klass.newInstance();
        }
        catch (ClassNotFoundException | InstantiationException | NoClassDefFoundError e) {
            OutputController.getLogger().log(e);
            Class<?> klass = Class.forName(NORMAL_PARSER_CLASS);
            instance = klass.newInstance();
        }
        switch (instance.getClass().getName()) {
            case "net.sourceforge.jnlp.MalformedXMLParser": {
                ParseException.setUsed(ParseException.UsedParsers.MALFORMED);
                break;
            }
            case "net.sourceforge.jnlp.XMLParser": {
                ParseException.setUsed(ParseException.UsedParsers.NORMAL);
            }
        }
        return instance;
    }

    private String getOptionalMainClass(Node node) {
        try {
            return this.getMainClass(node, false);
        }
        catch (ParseException ex) {
            OutputController.getLogger().log(ex);
            return null;
        }
    }

    private String getMainClass(Node node, boolean required) throws ParseException {
        String main = required ? this.getRequiredAttribute(node, MAINCLASS, null) : this.getAttribute(node, MAINCLASS, null);
        return this.cleanMainClassAttribute(main);
    }

    private String cleanMainClassAttribute(String main) throws ParseException {
        if (main != null) {
            Matcher matcher = anyWhiteSpace.matcher(main);
            boolean found = matcher.find();
            if (found && !this.strict) {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "Warning! main-class contains whitespace - '" + main + "'");
                main = main.trim();
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "Trimmed - '" + main + "'");
            }
            boolean valid = true;
            if (!Character.isJavaIdentifierStart(main.charAt(0))) {
                valid = false;
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Invlaid char in main-class: '" + main.charAt(0) + "'");
            }
            for (int i = 1; i < main.length(); ++i) {
                if (main.charAt(i) == '.' || Character.isJavaIdentifierPart(main.charAt(i))) continue;
                valid = false;
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Invlaid char in main-class: '" + main.charAt(i) + "'");
            }
            if (!valid) {
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, "main-class contains invalid characters - '" + main + "'. Check with vendor.");
                if (this.strict) {
                    throw new ParseException("main-class contains invalid characters - '" + main + "'. Check with vendor. You are in strict mode. This is fatal.");
                }
            }
        }
        return main;
    }
}

