/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.codec;

import java.util.ArrayList;
import java.util.List;
import org.jitsi.jicofo.JicofoConfig;
import org.jitsi.jicofo.codec.CodecUtil;
import org.jitsi.jicofo.codec.Config;
import org.jitsi.jicofo.codec.OfferOptions;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ExtmapAllowMixedPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;

public class JingleOfferFactory {
    public static final JingleOfferFactory INSTANCE = new JingleOfferFactory();

    public List<ContentPacketExtension> createOffer(OfferOptions options2) {
        ArrayList<ContentPacketExtension> contents = new ArrayList<ContentPacketExtension>();
        if (options2.getAudio()) {
            contents.add(this.createAudioContent(options2));
        }
        if (options2.getVideo()) {
            contents.add(this.createVideoContent(options2));
        }
        if (JicofoConfig.config.enableSctp() && options2.getSctp()) {
            contents.add(this.createDataContent(options2));
        }
        return contents;
    }

    private ContentPacketExtension createAudioContent(OfferOptions options2) {
        ContentPacketExtension content = JingleOfferFactory.createContentPacketExtension("audio");
        JingleOfferFactory.addAudioToContent(content, options2);
        return content;
    }

    private ContentPacketExtension createDataContent(OfferOptions options2) {
        ContentPacketExtension content = JingleOfferFactory.createContentPacketExtension("data");
        JingleOfferFactory.addDataToContent(content);
        return content;
    }

    private ContentPacketExtension createVideoContent(OfferOptions options2) {
        ContentPacketExtension videoContentPe = JingleOfferFactory.createContentPacketExtension("video");
        this.addVideoToContent(videoContentPe, options2);
        return videoContentPe;
    }

    private static ContentPacketExtension createContentPacketExtension(String name) {
        ContentPacketExtension content = new ContentPacketExtension(ContentPacketExtension.CreatorEnum.initiator, name);
        content.setSenders(ContentPacketExtension.SendersEnum.both);
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        iceUdpTransportPacketExtension.addChildExtension(new DtlsFingerprintPacketExtension());
        content.addChildExtension(iceUdpTransportPacketExtension);
        return content;
    }

    private void addVideoToContent(ContentPacketExtension content, OfferOptions options2) {
        RtpDescriptionPacketExtension rtpDesc = new RtpDescriptionPacketExtension();
        rtpDesc.setMedia("video");
        CodecUtil.Companion.createVideoPayloadTypeExtensions(options2).forEach(rtpDesc::addPayloadType);
        CodecUtil.Companion.createVideoRtpHdrExtExtensions(options2).forEach(rtpDesc::addExtmap);
        if (Config.config.getExtmapAllowMixed()) {
            rtpDesc.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
        }
        content.addChildExtension(rtpDesc);
    }

    private static void addAudioToContent(ContentPacketExtension content, OfferOptions options2) {
        RtpDescriptionPacketExtension rtpDesc = new RtpDescriptionPacketExtension();
        rtpDesc.setMedia("audio");
        CodecUtil.Companion.createAudioRtpHdrExtExtensions(options2).forEach(rtpDesc::addExtmap);
        CodecUtil.Companion.createAudioPayloadTypeExtensions(options2).forEach(rtpDesc::addPayloadType);
        if (Config.config.getExtmapAllowMixed()) {
            rtpDesc.setExtmapAllowMixed(new ExtmapAllowMixedPacketExtension());
        }
        rtpDesc.setAttribute("maxptime", "60");
        content.addChildExtension(rtpDesc);
    }

    private static void addDataToContent(ContentPacketExtension content) {
        RtpDescriptionPacketExtension rdpe = new RtpDescriptionPacketExtension();
        rdpe.setMedia("application");
        content.addChildExtension(rdpe);
    }
}

