/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.util.Arrays;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected static byte[] copyData(AbstractTlsSecret abstractTlsSecret) {
        return abstractTlsSecret.copyData();
    }

    protected AbstractTlsSecret(byte[] byArray) {
        this.data = byArray;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    public synchronized byte[] calculateHMAC(int n, byte[] byArray, int n2, int n3) {
        this.checkAlive();
        TlsHMAC tlsHMAC = this.getCrypto().createHMACForHash(n);
        tlsHMAC.setKey(this.data, 0, this.data.length);
        tlsHMAC.update(byArray, n2, n3);
        return tlsHMAC.calculateMAC();
    }

    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)0);
            this.data = null;
        }
    }

    public synchronized byte[] encrypt(TlsEncryptor tlsEncryptor) throws IOException {
        this.checkAlive();
        return tlsEncryptor.encrypt(this.data, 0, this.data.length);
    }

    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        return byArray;
    }

    public synchronized boolean isAlive() {
        return null != this.data;
    }

    synchronized byte[] copyData() {
        return Arrays.clone(this.data);
    }
}

