/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.attribute.Attribute;

public class SoftwareAttribute
extends Attribute {
    private byte[] software = null;

    protected SoftwareAttribute() {
        super('\u8022');
    }

    @Override
    void decodeAttributeBody(byte[] attributeValue, char offset, char length) {
        this.software = new byte[length];
        System.arraycopy(attributeValue, offset, this.software, 0, length);
    }

    @Override
    public byte[] encode() {
        char type2 = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + (4 - this.getDataLength() % 4) % 4];
        binValue[0] = (byte)(type2 >> 8);
        binValue[1] = (byte)(type2 & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.software, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    @Override
    public char getDataLength() {
        return (char)this.software.length;
    }

    @Override
    public String getName() {
        return "SOFTWARE";
    }

    public byte[] getSoftware() {
        if (this.software == null) {
            return null;
        }
        byte[] copy2 = new byte[this.software.length];
        System.arraycopy(this.software, 0, copy2, 0, this.software.length);
        return copy2;
    }

    public void setSoftware(byte[] software) {
        if (software == null) {
            this.software = null;
            return;
        }
        this.software = new byte[software.length];
        System.arraycopy(software, 0, this.software, 0, software.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SoftwareAttribute)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SoftwareAttribute att = (SoftwareAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.software, this.software);
    }
}

