/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.CandidateTcpType;
import org.ice4j.ice.Component;
import org.ice4j.ice.ComponentSocket;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.TcpHostCandidate;
import org.ice4j.ice.harvest.AbstractTcpListener;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.HarvestStatistics;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceTcpSocketWrapper;
import org.ice4j.socket.MultiplexingSocket;
import org.ice4j.socket.StunDatagramPacketFilter;

public class TcpHarvester
extends AbstractTcpListener
implements CandidateHarvester {
    private static final Logger logger = Logger.getLogger(TcpHarvester.class.getName());
    private static final int PURGE_INTERVAL = 20;
    private final Map<String, WeakReference<Component>> components = new HashMap<String, WeakReference<Component>>();
    private final Map<InetAddress, InetAddress> mappedAddresses = new HashMap<InetAddress, InetAddress>();
    private final Set<Integer> mappedPorts = new HashSet<Integer>();
    private int purgeCounter = 0;
    private final boolean ssltcp;
    private HarvestStatistics harvestStatistics = new HarvestStatistics();

    public TcpHarvester(int port2) throws IOException {
        super(port2);
        this.ssltcp = false;
        this.addMappedAddresses();
    }

    public TcpHarvester(int port2, boolean ssltcp) throws IOException {
        super(port2, Collections.list(NetworkInterface.getNetworkInterfaces()));
        this.ssltcp = ssltcp;
        this.addMappedAddresses();
    }

    public TcpHarvester(int port2, List<NetworkInterface> interfaces, boolean ssltcp) throws IOException {
        super(port2, interfaces);
        this.ssltcp = ssltcp;
        this.addMappedAddresses();
    }

    public TcpHarvester(List<TransportAddress> transportAddresses) throws IOException {
        super(transportAddresses);
        this.ssltcp = false;
        this.addMappedAddresses();
    }

    public TcpHarvester(List<TransportAddress> transportAddresses, boolean ssltcp) throws IOException {
        super(transportAddresses);
        this.ssltcp = ssltcp;
        this.addMappedAddresses();
    }

    private void addMappedAddresses() {
        for (MappingCandidateHarvester harvester : MappingCandidateHarvesters.getHarvesters()) {
            this.addMappedAddress(harvester.getMask().getAddress(), harvester.getFace().getAddress());
        }
    }

    public void addMappedAddress(InetAddress publicAddress, InetAddress localAddress) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding a mapped address: " + localAddress + " => " + publicAddress);
        }
        this.mappedAddresses.put(publicAddress, localAddress);
    }

    public void addMappedPort(int port2) {
        this.mappedPorts.add(port2);
    }

    private List<LocalCandidate> createLocalCandidates(Component component) {
        LinkedList<TcpHostCandidate> hostCandidates = new LinkedList<TcpHostCandidate>();
        for (Object transportAddress : this.localAddresses) {
            TcpHostCandidate tcpHostCandidate = new TcpHostCandidate((TransportAddress)transportAddress, component);
            tcpHostCandidate.setTcpType(CandidateTcpType.PASSIVE);
            if (this.ssltcp) {
                tcpHostCandidate.setSSL(true);
            }
            hostCandidates.add(tcpHostCandidate);
        }
        LinkedList<ServerReflexiveCandidate> mappedCandidates = new LinkedList<ServerReflexiveCandidate>();
        for (Map.Entry entry : this.mappedAddresses.entrySet()) {
            InetAddress inetAddress = (InetAddress)entry.getValue();
            for (TcpHostCandidate base : hostCandidates) {
                TransportAddress baseTransportAddress = base.getTransportAddress();
                if (!inetAddress.equals(baseTransportAddress.getAddress())) continue;
                InetAddress publicAddress = (InetAddress)entry.getKey();
                ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(new TransportAddress(publicAddress, baseTransportAddress.getPort(), Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    mappedCandidate.setSSL(true);
                }
                mappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                mappedCandidates.add(mappedCandidate);
            }
        }
        LinkedList<ServerReflexiveCandidate> portMappedCandidates = new LinkedList<ServerReflexiveCandidate>();
        for (TcpHostCandidate tcpHostCandidate : hostCandidates) {
            for (Integer port2 : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(tcpHostCandidate.getTransportAddress().getAddress(), (int)port2, Transport.TCP), tcpHostCandidate, tcpHostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (tcpHostCandidate.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                portMappedCandidates.add(portMappedCandidate);
            }
        }
        for (LocalCandidate localCandidate : mappedCandidates) {
            TcpHostCandidate base = (TcpHostCandidate)localCandidate.getBase();
            for (Integer port3 : this.mappedPorts) {
                ServerReflexiveCandidate portMappedCandidate = new ServerReflexiveCandidate(new TransportAddress(localCandidate.getTransportAddress().getAddress(), (int)port3, Transport.TCP), base, base.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
                if (base.isSSL()) {
                    portMappedCandidate.setSSL(true);
                }
                portMappedCandidate.setTcpType(CandidateTcpType.PASSIVE);
                portMappedCandidates.add(portMappedCandidate);
            }
        }
        LinkedList<LocalCandidate> linkedList = new LinkedList<LocalCandidate>();
        linkedList.addAll(hostCandidates);
        linkedList.addAll(mappedCandidates);
        linkedList.addAll(portMappedCandidates);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component getComponent(String localUfrag) {
        Map<String, WeakReference<Component>> map = this.components;
        synchronized (map) {
            WeakReference<Component> wr = this.components.get(localUfrag);
            if (wr != null) {
                Component component = (Component)wr.get();
                if (component == null) {
                    this.components.remove(localUfrag);
                }
                return component;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        IceMediaStream stream = component.getParentStream();
        Agent agent = stream.getParentAgent();
        if (stream.getComponentCount() != 1 || agent.getStreamCount() != 1) {
            logger.info("More than one Component for an Agent, cannot harvest.");
            return new LinkedList<LocalCandidate>();
        }
        List<LocalCandidate> candidates = this.createLocalCandidates(component);
        for (LocalCandidate candidate : candidates) {
            component.addLocalCandidate(candidate);
        }
        Map<String, WeakReference<Component>> map = this.components;
        synchronized (map) {
            this.components.put(agent.getLocalUfrag(), new WeakReference<Component>(component));
            this.purgeComponents();
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeComponents() {
        ++this.purgeCounter;
        if (this.purgeCounter % 20 == 0) {
            Map<String, WeakReference<Component>> map = this.components;
            synchronized (map) {
                Iterator<WeakReference<Component>> i = this.components.values().iterator();
                while (i.hasNext()) {
                    if (i.next().get() != null) continue;
                    i.remove();
                }
            }
        }
    }

    @Override
    protected void acceptSession(Socket socket, String ufrag, DatagramPacket pushback) throws IOException, IllegalStateException {
        Component component = this.getComponent(ufrag);
        if (component == null) {
            throw new IllegalStateException("No component found for ufrag " + ufrag);
        }
        this.addSocketToComponent(socket, component, pushback);
    }

    private void addSocketToComponent(Socket socket, Component component, DatagramPacket datagramPacket) throws IOException, IllegalStateException {
        IceProcessingState state = component.getParentStream().getParentAgent().getState();
        if (!IceProcessingState.WAITING.equals((Object)state) && !IceProcessingState.RUNNING.equals((Object)state)) {
            if (component.getComponentSocket() == null) {
                throw new IllegalStateException("The associated Agent is in state " + (Object)((Object)state) + " and we are not using a component socket");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding a socket to an Agent in state " + (Object)((Object)state));
            }
        }
        IceTcpSocketWrapper candidateSocket = null;
        IceSocketWrapper stunSocket = null;
        MultiplexingSocket multiplexing = new MultiplexingSocket(socket);
        candidateSocket = new IceTcpSocketWrapper(multiplexing);
        stunSocket = new IceTcpSocketWrapper(multiplexing.getSocket(new StunDatagramPacketFilter()));
        stunSocket = new AbstractTcpListener.PushBackIceSocketWrapper(stunSocket, datagramPacket);
        TcpHostCandidate candidate = this.findCandidate(component, socket);
        if (candidate == null) {
            throw new IOException("Failed to find the local candidate for socket: " + socket);
        }
        component.getParentStream().getParentAgent().getStunStack().addSocket(stunSocket);
        candidate.addSocket(candidateSocket);
        ComponentSocket componentSocket = component.getComponentSocket();
        if (componentSocket != null) {
            componentSocket.add(multiplexing);
        }
    }

    private TcpHostCandidate findCandidate(Component component, Socket socket) {
        InetAddress localAddress = socket.getLocalAddress();
        int localPort = socket.getLocalPort();
        for (LocalCandidate candidate : component.getLocalCandidates()) {
            TransportAddress transportAddress = candidate.getTransportAddress();
            if (!(candidate instanceof TcpHostCandidate) || !Transport.TCP.equals((Object)transportAddress.getTransport()) || localPort != transportAddress.getPort() || !localAddress.equals(transportAddress.getAddress())) continue;
            return (TcpHostCandidate)candidate;
        }
        return null;
    }

    @Override
    public boolean isHostHarvester() {
        return true;
    }

    @Override
    public HarvestStatistics getHarvestStatistics() {
        return this.harvestStatistics;
    }
}

