/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.MediaSourceDescKt;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.SetMediaSourcesEvent;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.TransformerNode;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoQualityLayerLookup;", "Lorg/jitsi/nlj/transform/node/TransformerNode;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "numPacketsDroppedNoEncoding", "Ljava/util/concurrent/atomic/AtomicInteger;", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "[Lorg/jitsi/nlj/MediaSourceDesc;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "trace", "f", "Lkotlin/Function0;", "transform", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "jitsi-media-transform"})
public final class VideoQualityLayerLookup
extends TransformerNode {
    @NotNull
    private final Logger logger;
    @NotNull
    private MediaSourceDesc[] sources;
    @NotNull
    private final AtomicInteger numPacketsDroppedNoEncoding;

    public VideoQualityLayerLookup(@NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super("Video quality layer lookup");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.sources = new MediaSourceDesc[0];
        this.numPacketsDroppedNoEncoding = new AtomicInteger();
    }

    @Override
    @Nullable
    protected PacketInfo transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        VideoRtpPacket videoPacket = (VideoRtpPacket)packetInfo.packetAs();
        RtpLayerDesc rtpLayerDesc = MediaSourceDescKt.findRtpLayerDesc(this.sources, videoPacket);
        if (rtpLayerDesc == null) {
            VideoQualityLayerLookup $this$transform_u24lambda_u2d0 = this;
            boolean bl = false;
            $this$transform_u24lambda_u2d0.logger.warn("Unable to find encoding matching packet! packet=" + videoPacket + "; sources=" + ArraysKt.joinToString$default($this$transform_u24lambda_u2d0.sources, (CharSequence)"\n", null, null, 0, null, null, 62, null));
            $this$transform_u24lambda_u2d0.numPacketsDroppedNoEncoding.incrementAndGet();
            return null;
        }
        RtpLayerDesc encodingDesc = rtpLayerDesc;
        videoPacket.setQualityIndex(encodingDesc.getIndex());
        return packetInfo;
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetMediaSourcesEvent) {
            this.sources = ((SetMediaSourcesEvent)event).getMediaSourceDescs();
        }
        super.handleEvent(event);
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d1 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d1.addNumber("num_packets_dropped_no_encoding", this.numPacketsDroppedNoEncoding.get());
        return nodeStatsBlock;
    }
}

