/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb;

import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/NackBlock;", "", "missingSeqNums", "Ljava/util/SortedSet;", "", "(Ljava/util/SortedSet;)V", "getMissingSeqNums", "()Ljava/util/SortedSet;", "writeTo", "", "buf", "", "offset", "Companion", "rtp"})
final class NackBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SortedSet<Integer> missingSeqNums;
    public static final int SIZE_BYTES = 4;

    public NackBlock(@NotNull SortedSet<Integer> missingSeqNums2) {
        Intrinsics.checkNotNullParameter(missingSeqNums2, "missingSeqNums");
        this.missingSeqNums = missingSeqNums2;
    }

    public /* synthetic */ NackBlock(SortedSet sortedSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sortedSet = SetsKt.sortedSetOf(new Integer[0]);
        }
        this(sortedSet);
    }

    @NotNull
    public final SortedSet<Integer> getMissingSeqNums() {
        return this.missingSeqNums;
    }

    public final void writeTo(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter(buf, "buf");
        Companion.putMissingSeqNums(buf, offset, this.missingSeqNums);
    }

    public NackBlock() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/NackBlock$Companion;", "", "()V", "SIZE_BYTES", "", "getMissingSeqNums", "", "buf", "", "offset", "putMissingSeqNums", "", "missingSeqNums", "Ljava/util/SortedSet;", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Integer> getMissingSeqNums(@NotNull byte[] buf, int offset) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            int packetId = UnsignedKt.toPositiveInt(ByteArrayExtensionsKt.getShort(buf, offset + 0));
            int blp = UnsignedKt.toPositiveInt(ByteArrayExtensionsKt.getShort(buf, offset + 2));
            Integer[] integerArray = new Integer[]{packetId};
            List<Integer> missingSeqNums2 = CollectionsKt.mutableListOf(integerArray);
            for (int shiftAmount = 0; shiftAmount < 16; ++shiftAmount) {
                if ((blp >>> shiftAmount & 1) != 1) continue;
                missingSeqNums2.add(packetId + shiftAmount + 1 & 0xFFFF);
            }
            return missingSeqNums2;
        }

        public final void putMissingSeqNums(@NotNull byte[] buf, int offset, @NotNull SortedSet<Integer> missingSeqNums2) {
            Intrinsics.checkNotNullParameter(buf, "buf");
            Intrinsics.checkNotNullParameter(missingSeqNums2, "missingSeqNums");
            Integer packetId = missingSeqNums2.first();
            ByteArrayExtensionsKt.putShort(buf, offset, (short)packetId.intValue());
            int blpField = 0;
            for (int bitPos = 16; 0 < bitPos; --bitPos) {
                Intrinsics.checkNotNullExpressionValue(packetId, "packetId");
                if (missingSeqNums2.contains(bitPos + packetId)) {
                    blpField |= 1;
                }
                if (bitPos == 1) continue;
                blpField <<= 1;
            }
            ByteArrayExtensionsKt.putShort(buf, offset + 2, (short)blpField);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

