/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.util;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.TimeUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/rtp/util/RtpUtils;", "", "()V", "Companion", "rtp"})
public final class RtpUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final int getSequenceNumberDelta(int a, int b) {
        return Companion.getSequenceNumberDelta(a, b);
    }

    @JvmStatic
    public static final int applySequenceNumberDelta(int start, int delta) {
        return Companion.applySequenceNumberDelta(start, delta);
    }

    @JvmStatic
    public static final long applyTimestampDelta(long start, long delta) {
        return Companion.applyTimestampDelta(start, delta);
    }

    @JvmStatic
    public static final boolean isNewerSequenceNumberThan(int a, int b) {
        return Companion.isNewerSequenceNumberThan(a, b);
    }

    @JvmStatic
    public static final boolean isOlderSequenceNumberThan(int a, int b) {
        return Companion.isOlderSequenceNumberThan(a, b);
    }

    @JvmStatic
    public static final boolean isNewerTimestampThan(long a, long b) {
        return Companion.isNewerTimestampThan(a, b);
    }

    @JvmStatic
    public static final boolean isOlderTimestampThan(long a, long b) {
        return Companion.isOlderTimestampThan(a, b);
    }

    @JvmStatic
    public static final long getTimestampDiff(long a, long b) {
        return Companion.getTimestampDiff(a, b);
    }

    @JvmStatic
    public static final long millisToNtpTimestamp(long timestampMs) {
        return Companion.millisToNtpTimestamp(timestampMs);
    }

    @JvmStatic
    public static final long convertRtpTimestampToMs(int rtpTimestamp, int ticksPerSecond) {
        return Companion.convertRtpTimestampToMs(rtpTimestamp, ticksPerSecond);
    }

    @JvmStatic
    @NotNull
    public static final Instant convertRtpTimestampToInstant(int rtpTimestamp, int ticksPerSecond) {
        return Companion.convertRtpTimestampToInstant(rtpTimestamp, ticksPerSecond);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0082\bJ\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0019\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0086\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0007J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0007J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004\u00a8\u0006$"}, d2={"Lorg/jitsi/rtp/util/RtpUtils$Companion;", "", "()V", "applySequenceNumberDelta", "", "start", "delta", "applyTimestampDelta", "", "calculateRtcpLengthFieldValue", "sizeBytes", "convertRtpTimestampToInstant", "Ljava/time/Instant;", "rtpTimestamp", "ticksPerSecond", "convertRtpTimestampToMs", "getNumPaddingBytes", "dataSizeBytes", "getSequenceNumberDelta", "a", "b", "getSequenceNumberDeltaAsShort", "", "getTimestampDiff", "getTimestampDiffAsInt", "isNewerSequenceNumberThan", "", "isNewerTimestampThan", "isOlderSequenceNumberThan", "isOlderTimestampThan", "millisToNtpTimestamp", "timestampMs", "sequenceNumbersBetween", "Lkotlin/sequences/Sequence;", "olderSeqNum", "newerSeqNum", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public final int calculateRtcpLengthFieldValue(int sizeBytes2) {
            if (sizeBytes2 % 4 != 0) {
                throw new Exception("Invalid RTCP size value");
            }
            return sizeBytes2 / 4 - 1;
        }

        public final int getNumPaddingBytes(int dataSizeBytes) {
            int n;
            switch (dataSizeBytes % 4) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 3;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }

        @JvmStatic
        public final int getSequenceNumberDelta(int a, int b) {
            Companion this_$iv = this;
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a - b);
        }

        private final short getSequenceNumberDeltaAsShort(int a, int b) {
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a - b);
        }

        @JvmStatic
        public final int applySequenceNumberDelta(int start, int delta) {
            return start + delta & 0xFFFF;
        }

        @JvmStatic
        public final long applyTimestampDelta(long start, long delta) {
            return start + delta & 0xFFFFFFFFL;
        }

        @JvmStatic
        public final boolean isNewerSequenceNumberThan(int a, int b) {
            Companion this_$iv = this;
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a - b) > 0;
        }

        @JvmStatic
        public final boolean isOlderSequenceNumberThan(int a, int b) {
            Companion this_$iv = this;
            boolean $i$f$getSequenceNumberDeltaAsShort = false;
            return (short)(a - b) < 0;
        }

        @JvmStatic
        public final boolean isNewerTimestampThan(long a, long b) {
            Companion this_$iv = this;
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a - b) > 0;
        }

        @JvmStatic
        public final boolean isOlderTimestampThan(long a, long b) {
            Companion this_$iv = this;
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a - b) < 0;
        }

        @JvmStatic
        public final long getTimestampDiff(long a, long b) {
            Companion this_$iv = this;
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a - b);
        }

        public final int getTimestampDiffAsInt(long a, long b) {
            boolean $i$f$getTimestampDiffAsInt = false;
            return (int)(a - b);
        }

        @NotNull
        public final Sequence<Integer> sequenceNumbersBetween(int olderSeqNum, int newerSeqNum) {
            Ref.IntRef currSeqNum = new Ref.IntRef();
            currSeqNum.element = olderSeqNum;
            return SequencesKt.generateSequence((Function0)new Function0<Integer>(currSeqNum, newerSeqNum){
                final /* synthetic */ Ref.IntRef $currSeqNum;
                final /* synthetic */ int $newerSeqNum;
                {
                    this.$currSeqNum = $currSeqNum;
                    this.$newerSeqNum = $newerSeqNum;
                    super(0);
                }

                @Nullable
                public final Integer invoke() {
                    this.$currSeqNum.element = (this.$currSeqNum.element + 1) % 65536;
                    return this.$currSeqNum.element == this.$newerSeqNum ? (Integer)null : Integer.valueOf(this.$currSeqNum.element);
                }
            });
        }

        @JvmStatic
        public final long millisToNtpTimestamp(long timestampMs) {
            return TimeUtils.toNtpTime(timestampMs);
        }

        @JvmStatic
        public final long convertRtpTimestampToMs(int rtpTimestamp, int ticksPerSecond) {
            return (long)((double)rtpTimestamp / (double)ticksPerSecond * (double)1000);
        }

        @JvmStatic
        @NotNull
        public final Instant convertRtpTimestampToInstant(int rtpTimestamp, int ticksPerSecond) {
            Instant instant = Instant.EPOCH.plus(Duration.ofSeconds(rtpTimestamp).dividedBy(ticksPerSecond));
            Intrinsics.checkNotNullExpressionValue(instant, "EPOCH.plus(Duration.ofSe\u2026ticksPerSecond.toLong()))");
            return instant;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

