/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.SendSource;
import org.jitsi.videobridge.SourceDesc;
import org.jitsi.videobridge.SsrcCache;
import org.jitsi.videobridge.SsrcRewriter;
import org.jitsi.videobridge.message.AudioSourceMapping;
import org.jitsi.videobridge.message.AudioSourcesMap;
import org.jitsi.videobridge.relay.AudioSourceDesc;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/videobridge/AudioSsrcCache;", "Lorg/jitsi/videobridge/SsrcCache;", "size", "", "ep", "Lorg/jitsi/videobridge/SsrcRewriter;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(ILorg/jitsi/videobridge/SsrcRewriter;Lorg/jitsi/utils/logging2/Logger;)V", "allowCreateOnPacket", "", "getAllowCreateOnPacket", "()Z", "findSourceProps", "Lorg/jitsi/videobridge/SourceDesc;", "ssrc", "", "notifyMappings", "", "sources", "", "Lorg/jitsi/videobridge/SendSource;", "jitsi-videobridge"})
public final class AudioSsrcCache
extends SsrcCache {
    private final boolean allowCreateOnPacket;

    public AudioSsrcCache(int size, @NotNull SsrcRewriter ep, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(ep, "ep");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        String string = MediaType.AUDIO.toString();
        Intrinsics.checkNotNullExpressionValue(string, "AUDIO.toString()");
        super(size, ep, parentLogger, string);
        this.allowCreateOnPacket = true;
    }

    @Override
    protected boolean getAllowCreateOnPacket() {
        return this.allowCreateOnPacket;
    }

    @Override
    @Nullable
    protected SourceDesc findSourceProps(long ssrc2) {
        AudioSourceDesc p = this.getEp().findAudioSourceProps(ssrc2);
        if (p == null || p.getSourceName() == null || p.getOwner() == null) {
            return null;
        }
        return new SourceDesc(p);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void notifyMappings(@NotNull List<SendSource> sources) {
        List list;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sources, "sources");
        Iterable $this$map$iv = sources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SendSource sendSource = (SendSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SourceDesc props = it.getProps();
            collection.add(new AudioSourceMapping(props.getName(), props.getOwner(), it.getSend1().getSsrc()));
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.getEp().sendMessage(new AudioSourcesMap(it));
    }
}

