/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.AdaptiveSourceProjection;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BitrateController;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bJ\u000e\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\u0012\u0010(\u001a\u0004\u0018\u00010\u000f2\u0006\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010\u0010\u001a\u00020\u0011*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0/H\u0002R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jitsi/videobridge/cc/allocation/PacketHandler;", "", "clock", "Ljava/time/Clock;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "(Ljava/time/Clock;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/event/EventEmitter;)V", "adaptiveSourceProjectionMap", "", "", "Lorg/jitsi/videobridge/cc/AdaptiveSourceProjection;", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "firstMedia", "Ljava/time/Instant;", "logger", "numDroppedPacketsUnknownSsrc", "Ljava/util/concurrent/atomic/AtomicInteger;", "payloadTypes", "", "Lorg/jitsi/nlj/format/PayloadType;", "accept", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "addPayloadType", "", "payloadType", "allocationChanged", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "lookupOrCreateAdaptiveSourceProjection", "singleAllocation", "Lorg/jitsi/videobridge/cc/allocation/SingleAllocation;", "timeSinceFirstMedia", "Ljava/time/Duration;", "transformRtcp", "transformRtp", "", "jitsi-videobridge"})
public final class PacketHandler {
    @NotNull
    private final Clock clock;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final EventEmitter<BitrateController.EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @Nullable
    private Instant firstMedia;
    @NotNull
    private final AtomicInteger numDroppedPacketsUnknownSsrc;
    @NotNull
    private final Map<Byte, PayloadType> payloadTypes;
    @NotNull
    private final Map<Long, AdaptiveSourceProjection> adaptiveSourceProjectionMap;

    public PacketHandler(@NotNull Clock clock, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext, @NotNull EventEmitter<BitrateController.EventHandler> eventEmitter) {
        Intrinsics.checkNotNullParameter(clock, "clock");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(eventEmitter, "eventEmitter");
        this.clock = clock;
        this.diagnosticContext = diagnosticContext;
        this.eventEmitter = eventEmitter;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.numDroppedPacketsUnknownSsrc = new AtomicInteger(0);
        this.payloadTypes = new ConcurrentHashMap();
        this.adaptiveSourceProjectionMap = new ConcurrentHashMap();
    }

    public final boolean transformRtp(@NotNull PacketInfo packetInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        VideoRtpPacket videoPacket = (VideoRtpPacket)packetInfo.packetAs();
        if (this.firstMedia == null) {
            this.firstMedia = this.clock.instant();
        }
        AdaptiveSourceProjection adaptiveSourceProjection2 = this.adaptiveSourceProjectionMap.get(videoPacket.getSsrc());
        if (adaptiveSourceProjection2 == null) {
            return false;
        }
        AdaptiveSourceProjection adaptiveSourceProjection3 = adaptiveSourceProjection2;
        try {
            adaptiveSourceProjection3.rewriteRtp(packetInfo);
            if (PacketInfo.Companion.getENABLE_PAYLOAD_VERIFICATION()) {
                String expected = packetInfo.getPayloadVerification();
                String actual = videoPacket.getPayloadVerification();
                if (!Intrinsics.areEqual("", expected) && !Intrinsics.areEqual(expected, actual)) {
                    this.logger.warn("Payload unexpectedly modified! Expected: " + expected + ", actual: " + actual);
                }
            }
            bl = true;
        }
        catch (RewriteException e) {
            this.logger.warn("Failed to rewrite a packet.", e);
            bl = false;
        }
        return bl;
    }

    public final boolean accept(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        VideoRtpPacket videoPacket = (VideoRtpPacket)packetInfo.packetAs();
        AdaptiveSourceProjection adaptiveSourceProjection2 = this.adaptiveSourceProjectionMap.get(videoPacket.getSsrc());
        if (adaptiveSourceProjection2 == null) {
            this.logger.debug(() -> PacketHandler.accept$lambda-0(videoPacket));
            this.numDroppedPacketsUnknownSsrc.incrementAndGet();
            return false;
        }
        return adaptiveSourceProjection2.accept(packetInfo);
    }

    public final boolean accept(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        AdaptiveSourceProjection adaptiveSourceProjection2 = this.adaptiveSourceProjectionMap.get(rtcpSrPacket.getSenderSsrc());
        return adaptiveSourceProjection2 == null || adaptiveSourceProjection2.getTargetSsrc() == rtcpSrPacket.getSenderSsrc();
    }

    public final boolean transformRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        AdaptiveSourceProjection adaptiveSourceProjection2 = this.adaptiveSourceProjectionMap.get(rtcpSrPacket.getSenderSsrc());
        return adaptiveSourceProjection2 != null ? adaptiveSourceProjection2.rewriteRtcp(rtcpSrPacket) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AdaptiveSourceProjection lookupOrCreateAdaptiveSourceProjection(SingleAllocation singleAllocation) {
        MediaSourceDesc source = singleAllocation.getMediaSource();
        String endpointID = singleAllocation.getEndpointId();
        if (source == null) {
            return null;
        }
        Map<Long, AdaptiveSourceProjection> map = this.adaptiveSourceProjectionMap;
        synchronized (map) {
            block8: {
                block7: {
                    boolean bl = false;
                    AdaptiveSourceProjection adaptiveSourceProjection2 = this.adaptiveSourceProjectionMap.get(source.getPrimarySSRC());
                    if (adaptiveSourceProjection2 == null) break block7;
                    AdaptiveSourceProjection it = adaptiveSourceProjection2;
                    boolean bl2 = false;
                    AdaptiveSourceProjection adaptiveSourceProjection3 = it;
                    return adaptiveSourceProjection3;
                }
                if (!(source.getRtpEncodings().length == 0)) break block8;
                AdaptiveSourceProjection adaptiveSourceProjection4 = null;
                return adaptiveSourceProjection4;
            }
            AdaptiveSourceProjection adaptiveSourceProjection5 = new AdaptiveSourceProjection(this.diagnosticContext, source, () -> PacketHandler.lookupOrCreateAdaptiveSourceProjection$lambda-5$lambda-2(this, endpointID, source), this.payloadTypes, this.logger);
            this.logger.debug(() -> PacketHandler.lookupOrCreateAdaptiveSourceProjection$lambda-5$lambda-3(source));
            RtpEncodingDesc[] $this$forEach$iv = source.getRtpEncodings();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                RtpEncodingDesc element$iv;
                RtpEncodingDesc it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.adaptiveSourceProjectionMap.put(it.getPrimarySSRC(), adaptiveSourceProjection5);
            }
            AdaptiveSourceProjection adaptiveSourceProjection6 = adaptiveSourceProjection5;
            return adaptiveSourceProjection6;
        }
    }

    @NotNull
    public final Duration timeSinceFirstMedia() {
        Duration duration;
        Duration duration2;
        Instant instant = this.firstMedia;
        if (instant != null) {
            Instant it = instant;
            boolean bl = false;
            duration2 = Duration.between(it, this.clock.instant());
        } else {
            duration2 = duration = null;
        }
        if (duration2 == null) {
            Duration duration3 = Duration.ZERO;
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue(duration3, "ZERO");
        }
        return duration;
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.payloadTypes.put(payloadType.getPt(), payloadType);
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u2d7 = jSONObject = new JSONObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u2d7).put("numDroppedPacketsUnknownSsrc", this.numDroppedPacketsUnknownSsrc.intValue());
        ((Map)$this$_get_debugState__u24lambda_u2d7).put("adaptiveSourceProjectionMap", this.debugState(this.adaptiveSourceProjectionMap));
        return jSONObject;
    }

    private final JSONObject debugState(Map<Long, ? extends AdaptiveSourceProjection> $this$debugState) {
        JSONObject jSONObject;
        JSONObject it = jSONObject = new JSONObject();
        boolean bl = false;
        Map<Long, ? extends AdaptiveSourceProjection> $this$forEach$iv = $this$debugState;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, ? extends AdaptiveSourceProjection>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, ? extends AdaptiveSourceProjection> element$iv;
            Map.Entry<Long, ? extends AdaptiveSourceProjection> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            long ssrc2 = ((Number)entry.getKey()).longValue();
            AdaptiveSourceProjection adaptiveSourceProjection2 = entry.getValue();
            Long l = ssrc2;
            ((Map)it).put(l, adaptiveSourceProjection2.getDebugState());
        }
        return jSONObject;
    }

    public final void allocationChanged(@NotNull BandwidthAllocation allocation) {
        Intrinsics.checkNotNullParameter(allocation, "allocation");
        if (allocation.getAllocations().isEmpty()) {
            Iterable $this$forEach$iv = this.adaptiveSourceProjectionMap.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdaptiveSourceProjection it = (AdaptiveSourceProjection)element$iv;
                boolean bl = false;
                it.setTargetIndex(-1);
            }
        } else {
            Iterable $this$forEach$iv = allocation.getAllocations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AdaptiveSourceProjection adaptiveSourceProjection2;
                SingleAllocation it = (SingleAllocation)element$iv;
                boolean bl = false;
                RtpLayerDesc rtpLayerDesc = it.getTargetLayer();
                int sourceTargetIdx = rtpLayerDesc != null ? rtpLayerDesc.getIndex() : -1;
                AdaptiveSourceProjection adaptiveSourceProjection3 = adaptiveSourceProjection2 = this.lookupOrCreateAdaptiveSourceProjection(it);
                if (adaptiveSourceProjection3 == null) continue;
                adaptiveSourceProjection3.setTargetIndex(sourceTargetIdx);
            }
        }
    }

    private static final String accept$lambda-0(VideoRtpPacket $videoPacket) {
        Intrinsics.checkNotNullParameter($videoPacket, "$videoPacket");
        return "Dropping an RTP packet for an unknown SSRC: " + $videoPacket.getSsrc();
    }

    private static final void lookupOrCreateAdaptiveSourceProjection$lambda-5$lambda-2(PacketHandler this$0, String $endpointID, MediaSourceDesc $source) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($endpointID, "$endpointID");
        this$0.eventEmitter.fireEvent(new Function1<BitrateController.EventHandler, Unit>($endpointID, $source){
            final /* synthetic */ String $endpointID;
            final /* synthetic */ MediaSourceDesc $source;
            {
                this.$endpointID = $endpointID;
                this.$source = $source;
                super(1);
            }

            public final void invoke(@NotNull BitrateController.EventHandler $this$fireEvent) {
                Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                $this$fireEvent.keyframeNeeded(this.$endpointID, this.$source.getPrimarySSRC());
            }
        });
    }

    private static final String lookupOrCreateAdaptiveSourceProjection$lambda-5$lambda-3(MediaSourceDesc $source) {
        return "new source projection for " + $source;
    }
}

