/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.ice;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.DoubleAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.BucketStats;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceStatistics;", "", "()V", "combinedStats", "Lorg/jitsi/videobridge/transport/ice/IceStatistics$Stats;", "statsByHarvesterName", "Ljava/util/concurrent/ConcurrentHashMap;", "", "add", "", "harvesterName", "rttMs", "", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "Companion", "Stats", "jitsi-videobridge"})
public final class IceStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Stats combinedStats = new Stats();
    @NotNull
    private final ConcurrentHashMap<String, Stats> statsByHarvesterName = new ConcurrentHashMap();
    @NotNull
    private static final IceStatistics stats = new IceStatistics();

    public final void add(@NotNull String harvesterName, double rttMs) {
        Intrinsics.checkNotNullParameter(harvesterName, "harvesterName");
        this.combinedStats.add(rttMs);
        this.statsByHarvesterName.computeIfAbsent(harvesterName, IceStatistics::add$lambda-0).add(rttMs);
    }

    @NotNull
    public final OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$toJson_u24lambda_u2d2 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u2d2.put("all", this.combinedStats.toJson());
        Map $this$forEach$iv = this.statsByHarvesterName;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String harvesterName = (String)entry.getKey();
            Stats stats = (Stats)entry.getValue();
            $this$toJson_u24lambda_u2d2.put(harvesterName, stats.toJson());
        }
        return orderedJsonObject;
    }

    private static final Stats add$lambda-0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new Stats();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceStatistics$Companion;", "", "()V", "stats", "Lorg/jitsi/videobridge/transport/ice/IceStatistics;", "getStats", "()Lorg/jitsi/videobridge/transport/ice/IceStatistics;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IceStatistics getStats() {
            return stats;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceStatistics$Stats;", "", "()V", "buckets", "Lorg/jitsi/utils/stats/BucketStats;", "getBuckets", "()Lorg/jitsi/utils/stats/BucketStats;", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "sum", "Ljava/util/concurrent/atomic/DoubleAdder;", "getSum", "()Ljava/util/concurrent/atomic/DoubleAdder;", "setSum", "(Ljava/util/concurrent/atomic/DoubleAdder;)V", "add", "", "rttMs", "", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-videobridge"})
    private static final class Stats {
        @NotNull
        private final BucketStats buckets;
        @NotNull
        private DoubleAdder sum;
        @NotNull
        private AtomicInteger count;

        public Stats() {
            Long[] longArray = new Long[]{0L, 10L, 20L, 40L, 60L, 80L, 100L, 150L, 200L, 250L, 300L, 500L, 1000L, Long.MAX_VALUE};
            this.buckets = new BucketStats(CollectionsKt.listOf(longArray), null, null, 6, null);
            this.sum = new DoubleAdder();
            this.count = new AtomicInteger();
        }

        @NotNull
        public final BucketStats getBuckets() {
            return this.buckets;
        }

        @NotNull
        public final DoubleAdder getSum() {
            return this.sum;
        }

        public final void setSum(@NotNull DoubleAdder doubleAdder) {
            Intrinsics.checkNotNullParameter(doubleAdder, "<set-?>");
            this.sum = doubleAdder;
        }

        @NotNull
        public final AtomicInteger getCount() {
            return this.count;
        }

        public final void setCount(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkNotNullParameter(atomicInteger, "<set-?>");
            this.count = atomicInteger;
        }

        public final void add(double rttMs) {
            this.sum.add(rttMs);
            this.count.incrementAndGet();
            this.buckets.addValue((long)(rttMs + 0.5));
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u2d0.put("average", (Object)(this.sum.sum() / this.count.doubleValue()));
            $this$toJson_u24lambda_u2d0.put("buckets", BucketStats.toJson$default(this.buckets, null, 1, null));
            return orderedJsonObject;
        }
    }
}

