/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import java.io.IOException;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class IdentityPacketExtension
implements ExtensionElement {
    public static final Logger logger = new LoggerImpl(IdentityPacketExtension.class.getName());
    public static final String NAMESPACE = "jabber:client";
    public static final String ELEMENT = "identity";
    public static final String USER_ELEMENT = "user";
    public static final String GROUP_ELEMENT = "group";
    public static final String USER_ID_ELEMENT = "id";
    public static final String USER_AVATAR_URL_ELEMENT = "avatar";
    public static final String USER_NAME_ELEMENT = "name";
    private String userId;
    private String userName;
    private String userAvatarUrl;
    private String groupId;

    public IdentityPacketExtension(String userId, String userName, String userAvatarUrl, String groupId) {
        this.userId = userId;
        this.userName = userName;
        this.userAvatarUrl = userAvatarUrl;
        this.groupId = groupId;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder();
        xml.openElement(ELEMENT);
        xml.openElement(USER_ELEMENT);
        if (this.getUserId() != null) {
            xml.element(USER_ID_ELEMENT, this.getUserId());
        }
        if (this.getUserName() != null) {
            xml.element(USER_NAME_ELEMENT, this.getUserName());
        }
        if (this.getUserAvatarUrl() != null) {
            xml.element(USER_AVATAR_URL_ELEMENT, this.getUserAvatarUrl());
        }
        xml.closeElement(USER_ELEMENT);
        if (this.getGroupId() != null) {
            xml.element(GROUP_ELEMENT, this.getGroupId());
        }
        xml.closeElement(ELEMENT);
        return xml.toString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserAvatarUrl() {
        return this.userAvatarUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public static class Provider
    extends ExtensionElementProvider<IdentityPacketExtension> {
        @Override
        public IdentityPacketExtension parse(XmlPullParser parser2, int depth, XmlEnvironment xmlEnvironment) {
            String currentTag = parser2.getName();
            if (!IdentityPacketExtension.NAMESPACE.equals(parser2.getNamespace())) {
                return null;
            }
            if (!IdentityPacketExtension.ELEMENT.equals(currentTag)) {
                return null;
            }
            String userId = null;
            String userName = null;
            String userAvatarUrl = null;
            String groupId = null;
            try {
                do {
                    parser2.next();
                    if (parser2.getEventType() == XmlPullParser.Event.START_ELEMENT) {
                        currentTag = parser2.getName();
                        continue;
                    }
                    if (parser2.getEventType() == XmlPullParser.Event.TEXT_CHARACTERS) {
                        switch (currentTag) {
                            case "avatar": {
                                userAvatarUrl = parser2.getText();
                                break;
                            }
                            case "id": {
                                userId = parser2.getText();
                                break;
                            }
                            case "name": {
                                userName = parser2.getText();
                                break;
                            }
                            case "group": {
                                groupId = parser2.getText();
                                break;
                            }
                        }
                        continue;
                    }
                    if (parser2.getEventType() != XmlPullParser.Event.END_ELEMENT) continue;
                    currentTag = parser2.getName();
                } while (!IdentityPacketExtension.ELEMENT.equals(currentTag));
            }
            catch (IOException | XmlPullParserException e) {
                logger.warn("failed to parse IdentityExtension", e);
            }
            return new IdentityPacketExtension(userId, userName, userAvatarUrl, groupId);
        }
    }
}

