/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.Dot11SsidElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.util.ByteArrays;

public final class Dot11SsidListElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 1424839847229135121L;
    private final List<Dot11SsidElement> ssidList;

    public static Dot11SsidListElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11SsidListElement(rawData, offset, length);
    }

    private Dot11SsidListElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.SSID_LIST);
        int infoLen = this.getLengthAsInt();
        this.ssidList = new ArrayList<Dot11SsidElement>();
        int i = offset + 2;
        while (infoLen > 0) {
            Dot11SsidElement ssid = Dot11SsidElement.newInstance(rawData, i, infoLen);
            this.ssidList.add(ssid);
            int ssidLen = ssid.length();
            infoLen -= ssidLen;
            i += ssidLen;
        }
    }

    private Dot11SsidListElement(Builder builder2) {
        super(builder2);
        this.ssidList = new ArrayList<Dot11SsidElement>(builder2.ssidList);
    }

    public List<Dot11SsidElement> getSsidList() {
        return new ArrayList<Dot11SsidElement>(this.ssidList);
    }

    @Override
    public int length() {
        int len = 2;
        for (Dot11SsidElement ssid : this.ssidList) {
            len += ssid.length();
        }
        return len;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        int offset = 2;
        for (Dot11SsidElement ssid : this.ssidList) {
            byte[] rawSsid = ssid.getRawData();
            System.arraycopy(rawSsid, 0, rawData, offset, rawSsid.length);
            offset += rawSsid.length;
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.ssidList.hashCode();
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11SsidListElement other = (Dot11SsidListElement)obj;
        return this.ssidList.equals(other.ssidList);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("SSID List:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        for (Dot11SsidElement ssid : this.ssidList) {
            sb.append(indent).append("  SSID: ").append(ssid.getSsid()).append(ls);
        }
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private List<Dot11SsidElement> ssidList;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.SSID_LIST.value()));
        }

        private Builder(Dot11SsidListElement elem) {
            super(elem);
            this.ssidList = elem.ssidList;
        }

        public Builder ssidList(List<Dot11SsidElement> ssidList) {
            this.ssidList = ssidList;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11SsidListElement build() {
            if (this.ssidList == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("ssidList: ").append(this.ssidList);
                throw new NullPointerException(sb.toString());
            }
            int len = 0;
            for (Dot11SsidElement ssid : this.ssidList) {
                len += ssid.length();
            }
            if (len > 255) {
                throw new IllegalArgumentException("Too long ssidList: " + this.ssidList);
            }
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)len);
            }
            return new Dot11SsidListElement(this);
        }
    }
}

