/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataChannel
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 3645927613193110605L;
    private static final int LENGTH = 4;
    private final short frequency;
    private final boolean lsbOfFlags;
    private final boolean secondLsbOfFlags;
    private final boolean thirdLsbOfFlags;
    private final boolean fourthLsbOfFlags;
    private final boolean turbo;
    private final boolean cck;
    private final boolean ofdm;
    private final boolean twoGhzSpectrum;
    private final boolean fiveGhzSpectrum;
    private final boolean onlyPassiveScan;
    private final boolean dynamicCckOfdm;
    private final boolean gfsk;
    private final boolean gsm;
    private final boolean staticTurbo;
    private final boolean halfRate;
    private final boolean quarterRate;

    public static RadiotapDataChannel newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataChannel(rawData, offset, length);
    }

    private RadiotapDataChannel(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapChannel (").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.frequency = ByteArrays.getShort(rawData, offset, ByteOrder.LITTLE_ENDIAN);
        this.lsbOfFlags = (rawData[offset + 2] & 1) != 0;
        this.secondLsbOfFlags = (rawData[offset + 2] & 2) != 0;
        this.thirdLsbOfFlags = (rawData[offset + 2] & 4) != 0;
        this.fourthLsbOfFlags = (rawData[offset + 2] & 8) != 0;
        this.turbo = (rawData[offset + 2] & 0x10) != 0;
        this.cck = (rawData[offset + 2] & 0x20) != 0;
        this.ofdm = (rawData[offset + 2] & 0x40) != 0;
        this.twoGhzSpectrum = (rawData[offset + 2] & 0x80) != 0;
        this.fiveGhzSpectrum = (rawData[offset + 3] & 1) != 0;
        this.onlyPassiveScan = (rawData[offset + 3] & 2) != 0;
        this.dynamicCckOfdm = (rawData[offset + 3] & 4) != 0;
        this.gfsk = (rawData[offset + 3] & 8) != 0;
        this.gsm = (rawData[offset + 3] & 0x10) != 0;
        this.staticTurbo = (rawData[offset + 3] & 0x20) != 0;
        this.halfRate = (rawData[offset + 3] & 0x40) != 0;
        this.quarterRate = (rawData[offset + 3] & 0x80) != 0;
    }

    private RadiotapDataChannel(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.frequency = builder2.frequency;
        this.lsbOfFlags = builder2.lsbOfFlags;
        this.secondLsbOfFlags = builder2.secondLsbOfFlags;
        this.thirdLsbOfFlags = builder2.thirdLsbOfFlags;
        this.fourthLsbOfFlags = builder2.fourthLsbOfFlags;
        this.turbo = builder2.turbo;
        this.cck = builder2.cck;
        this.ofdm = builder2.ofdm;
        this.twoGhzSpectrum = builder2.twoGhzSpectrum;
        this.fiveGhzSpectrum = builder2.fiveGhzSpectrum;
        this.onlyPassiveScan = builder2.onlyPassiveScan;
        this.dynamicCckOfdm = builder2.dynamicCckOfdm;
        this.gfsk = builder2.gfsk;
        this.gsm = builder2.gsm;
        this.staticTurbo = builder2.staticTurbo;
        this.halfRate = builder2.halfRate;
        this.quarterRate = builder2.quarterRate;
    }

    public short getFrequency() {
        return this.frequency;
    }

    public int getFrequencyAsInt() {
        return this.frequency & 0xFFFF;
    }

    public boolean getLsbOfFlags() {
        return this.lsbOfFlags;
    }

    public boolean getSecondLsbOfFlags() {
        return this.secondLsbOfFlags;
    }

    public boolean getThirdLsbOfFlags() {
        return this.thirdLsbOfFlags;
    }

    public boolean getFourthLsbOfFlags() {
        return this.fourthLsbOfFlags;
    }

    public boolean isTurbo() {
        return this.turbo;
    }

    public boolean isCck() {
        return this.cck;
    }

    public boolean isOfdm() {
        return this.ofdm;
    }

    public boolean isTwoGhzSpectrum() {
        return this.twoGhzSpectrum;
    }

    public boolean isFiveGhzSpectrum() {
        return this.fiveGhzSpectrum;
    }

    public boolean isOnlyPassiveScan() {
        return this.onlyPassiveScan;
    }

    public boolean isDynamicCckOfdm() {
        return this.dynamicCckOfdm;
    }

    public boolean isGfsk() {
        return this.gfsk;
    }

    public boolean isGsm() {
        return this.gsm;
    }

    public boolean isStaticTurbo() {
        return this.staticTurbo;
    }

    public boolean isHalfRate() {
        return this.halfRate;
    }

    public boolean isQuarterRate() {
        return this.quarterRate;
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] data2 = new byte[4];
        System.arraycopy(ByteArrays.toByteArray(this.frequency, ByteOrder.LITTLE_ENDIAN), 0, data2, 0, 2);
        if (this.lsbOfFlags) {
            data2[2] = (byte)(data2[2] | 1);
        }
        if (this.secondLsbOfFlags) {
            data2[2] = (byte)(data2[2] | 2);
        }
        if (this.thirdLsbOfFlags) {
            data2[2] = (byte)(data2[2] | 4);
        }
        if (this.fourthLsbOfFlags) {
            data2[2] = (byte)(data2[2] | 8);
        }
        if (this.turbo) {
            data2[2] = (byte)(data2[2] | 0x10);
        }
        if (this.cck) {
            data2[2] = (byte)(data2[2] | 0x20);
        }
        if (this.ofdm) {
            data2[2] = (byte)(data2[2] | 0x40);
        }
        if (this.twoGhzSpectrum) {
            data2[2] = (byte)(data2[2] | 0x80);
        }
        if (this.fiveGhzSpectrum) {
            data2[3] = (byte)(data2[3] | 1);
        }
        if (this.onlyPassiveScan) {
            data2[3] = (byte)(data2[3] | 2);
        }
        if (this.dynamicCckOfdm) {
            data2[3] = (byte)(data2[3] | 4);
        }
        if (this.gfsk) {
            data2[3] = (byte)(data2[3] | 8);
        }
        if (this.gsm) {
            data2[3] = (byte)(data2[3] | 0x10);
        }
        if (this.staticTurbo) {
            data2[3] = (byte)(data2[3] | 0x20);
        }
        if (this.halfRate) {
            data2[3] = (byte)(data2[3] | 0x40);
        }
        if (this.quarterRate) {
            data2[3] = (byte)(data2[3] | 0x80);
        }
        return data2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Channel: ").append(ls).append(indent).append("  Frequency: ").append(this.getFrequencyAsInt()).append(" MHz").append(ls).append(indent).append("  LSB of flags: ").append(this.lsbOfFlags).append(ls).append(indent).append("  2nd LSB of flags: ").append(this.secondLsbOfFlags).append(ls).append(indent).append("  3rd LSB of flags: ").append(this.thirdLsbOfFlags).append(ls).append(indent).append("  4th LSB of flags: ").append(this.fourthLsbOfFlags).append(ls).append(indent).append("  Turbo: ").append(this.turbo).append(ls).append(indent).append("  CCK: ").append(this.cck).append(ls).append(indent).append("  OFDM: ").append(this.ofdm).append(ls).append(indent).append("  2 GHz spectrum: ").append(this.twoGhzSpectrum).append(ls).append(indent).append("  5 GHz spectrum: ").append(this.fiveGhzSpectrum).append(ls).append(indent).append("  Only passive scan: ").append(this.onlyPassiveScan).append(ls).append(indent).append("  Dynamic CCK-OFDM: ").append(this.dynamicCckOfdm).append(ls).append(indent).append("  GFSK: ").append(this.gfsk).append(ls).append(indent).append("  GSM: ").append(this.gsm).append(ls).append(indent).append("  Static Turbo: ").append(this.staticTurbo).append(ls).append(indent).append("  Half rate: ").append(this.halfRate).append(ls).append(indent).append("  Quarter rate: ").append(this.quarterRate).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.cck ? 1231 : 1237);
        result2 = 31 * result2 + (this.dynamicCckOfdm ? 1231 : 1237);
        result2 = 31 * result2 + (this.fiveGhzSpectrum ? 1231 : 1237);
        result2 = 31 * result2 + (this.fourthLsbOfFlags ? 1231 : 1237);
        result2 = 31 * result2 + this.frequency;
        result2 = 31 * result2 + (this.gfsk ? 1231 : 1237);
        result2 = 31 * result2 + (this.gsm ? 1231 : 1237);
        result2 = 31 * result2 + (this.halfRate ? 1231 : 1237);
        result2 = 31 * result2 + (this.lsbOfFlags ? 1231 : 1237);
        result2 = 31 * result2 + (this.ofdm ? 1231 : 1237);
        result2 = 31 * result2 + (this.onlyPassiveScan ? 1231 : 1237);
        result2 = 31 * result2 + (this.quarterRate ? 1231 : 1237);
        result2 = 31 * result2 + (this.secondLsbOfFlags ? 1231 : 1237);
        result2 = 31 * result2 + (this.staticTurbo ? 1231 : 1237);
        result2 = 31 * result2 + (this.thirdLsbOfFlags ? 1231 : 1237);
        result2 = 31 * result2 + (this.turbo ? 1231 : 1237);
        result2 = 31 * result2 + (this.twoGhzSpectrum ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataChannel other = (RadiotapDataChannel)obj;
        if (this.cck != other.cck) {
            return false;
        }
        if (this.dynamicCckOfdm != other.dynamicCckOfdm) {
            return false;
        }
        if (this.fiveGhzSpectrum != other.fiveGhzSpectrum) {
            return false;
        }
        if (this.fourthLsbOfFlags != other.fourthLsbOfFlags) {
            return false;
        }
        if (this.frequency != other.frequency) {
            return false;
        }
        if (this.gfsk != other.gfsk) {
            return false;
        }
        if (this.gsm != other.gsm) {
            return false;
        }
        if (this.halfRate != other.halfRate) {
            return false;
        }
        if (this.lsbOfFlags != other.lsbOfFlags) {
            return false;
        }
        if (this.ofdm != other.ofdm) {
            return false;
        }
        if (this.onlyPassiveScan != other.onlyPassiveScan) {
            return false;
        }
        if (this.quarterRate != other.quarterRate) {
            return false;
        }
        if (this.secondLsbOfFlags != other.secondLsbOfFlags) {
            return false;
        }
        if (this.staticTurbo != other.staticTurbo) {
            return false;
        }
        if (this.thirdLsbOfFlags != other.thirdLsbOfFlags) {
            return false;
        }
        if (this.turbo != other.turbo) {
            return false;
        }
        return this.twoGhzSpectrum == other.twoGhzSpectrum;
    }

    public static final class Builder {
        private short frequency;
        private boolean lsbOfFlags;
        private boolean secondLsbOfFlags;
        private boolean thirdLsbOfFlags;
        private boolean fourthLsbOfFlags;
        private boolean turbo;
        private boolean cck;
        private boolean ofdm;
        private boolean twoGhzSpectrum;
        private boolean fiveGhzSpectrum;
        private boolean onlyPassiveScan;
        private boolean dynamicCckOfdm;
        private boolean gfsk;
        private boolean gsm;
        private boolean staticTurbo;
        private boolean halfRate;
        private boolean quarterRate;

        public Builder() {
        }

        private Builder(RadiotapDataChannel obj) {
            this.frequency = obj.frequency;
            this.lsbOfFlags = obj.lsbOfFlags;
            this.secondLsbOfFlags = obj.secondLsbOfFlags;
            this.thirdLsbOfFlags = obj.thirdLsbOfFlags;
            this.fourthLsbOfFlags = obj.fourthLsbOfFlags;
            this.turbo = obj.turbo;
            this.cck = obj.cck;
            this.ofdm = obj.ofdm;
            this.twoGhzSpectrum = obj.twoGhzSpectrum;
            this.fiveGhzSpectrum = obj.fiveGhzSpectrum;
            this.onlyPassiveScan = obj.onlyPassiveScan;
            this.dynamicCckOfdm = obj.dynamicCckOfdm;
            this.gfsk = obj.gfsk;
            this.gsm = obj.gsm;
            this.staticTurbo = obj.staticTurbo;
            this.halfRate = obj.halfRate;
            this.quarterRate = obj.quarterRate;
        }

        public Builder frequency(short frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder lsbOfFlags(boolean lsbOfFlags) {
            this.lsbOfFlags = lsbOfFlags;
            return this;
        }

        public Builder secondLsbOfFlags(boolean secondLsbOfFlags) {
            this.secondLsbOfFlags = secondLsbOfFlags;
            return this;
        }

        public Builder thirdLsbOfFlags(boolean thirdLsbOfFlags) {
            this.thirdLsbOfFlags = thirdLsbOfFlags;
            return this;
        }

        public Builder fourthLsbOfFlags(boolean fourthLsbOfFlags) {
            this.fourthLsbOfFlags = fourthLsbOfFlags;
            return this;
        }

        public Builder turbo(boolean turbo) {
            this.turbo = turbo;
            return this;
        }

        public Builder cck(boolean cck) {
            this.cck = cck;
            return this;
        }

        public Builder ofdm(boolean ofdm) {
            this.ofdm = ofdm;
            return this;
        }

        public Builder twoGhzSpectrum(boolean twoGhzSpectrum) {
            this.twoGhzSpectrum = twoGhzSpectrum;
            return this;
        }

        public Builder fiveGhzSpectrum(boolean fiveGhzSpectrum) {
            this.fiveGhzSpectrum = fiveGhzSpectrum;
            return this;
        }

        public Builder onlyPassiveScan(boolean onlyPassiveScan) {
            this.onlyPassiveScan = onlyPassiveScan;
            return this;
        }

        public Builder dynamicCckOfdm(boolean dynamicCckOfdm) {
            this.dynamicCckOfdm = dynamicCckOfdm;
            return this;
        }

        public Builder gfsk(boolean gfsk) {
            this.gfsk = gfsk;
            return this;
        }

        public Builder gsm(boolean gsm) {
            this.gsm = gsm;
            return this;
        }

        public Builder staticTurbo(boolean staticTurbo) {
            this.staticTurbo = staticTurbo;
            return this;
        }

        public Builder halfRate(boolean halfRate) {
            this.halfRate = halfRate;
            return this;
        }

        public Builder quarterRate(boolean quarterRate) {
            this.quarterRate = quarterRate;
            return this;
        }

        public RadiotapDataChannel build() {
            return new RadiotapDataChannel(this);
        }
    }
}

