/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class ImmutableGpxTrackSegment
implements GpxTrackSegment {
    private final List<WayPoint> wayPoints;
    private final Bounds bounds;
    private final double length;

    public ImmutableGpxTrackSegment(Collection<WayPoint> wayPoints) {
        this.wayPoints = Collections.unmodifiableList(new ArrayList<WayPoint>(wayPoints));
        this.bounds = this.calculateBounds();
        this.length = this.calculateLength();
    }

    private Bounds calculateBounds() {
        Bounds result = null;
        for (WayPoint wpt : this.wayPoints) {
            if (result == null) {
                result = new Bounds(wpt.getCoor());
                continue;
            }
            result.extend(wpt.getCoor());
        }
        return result;
    }

    private double calculateLength() {
        double result = 0.0;
        WayPoint last = null;
        for (WayPoint tpt : this.wayPoints) {
            Double d;
            if (last != null && !(d = Double.valueOf(last.getCoor().greatCircleDistance(tpt.getCoor()))).isNaN() && !d.isInfinite()) {
                result += d.doubleValue();
            }
            last = tpt;
        }
        return result;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds == null ? null : new Bounds(this.bounds);
    }

    @Override
    public Collection<WayPoint> getWayPoints() {
        return Collections.unmodifiableList(this.wayPoints);
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    public int hashCode() {
        return 31 + (this.wayPoints == null ? 0 : this.wayPoints.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableGpxTrackSegment other = (ImmutableGpxTrackSegment)obj;
        return !(this.wayPoints == null ? other.wayPoints != null : !this.wayPoints.equals(other.wayPoints));
    }
}

