/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.aesh.terminal.utils.Config;

public class PathResolver {
    private static final char SEPARATOR = Config.getPathSeparator().charAt(0);
    private static final char TILDE = '~';
    private static final String TILDE_WITH_SEPARATOR = "~" + Config.getPathSeparator();
    private static final char STAR = '*';
    private static final char WILDCARD = '?';
    private static final String PARENT = "..";
    private static final String PARENT_WITH_SEPARATOR = ".." + Config.getPathSeparator();
    private static final String ROOT = Config.getPathSeparator();
    private static final String DRIVER_SEPARATOR = ":";
    private static final String CURRENT_WITH_SEPARATOR = "." + Config.getPathSeparator();
    private static final String SEPARATOR_WITH_CURRENT = Config.getPathSeparator() + ".";
    private static final String SEPARATOR_CURRENT_SEPARATOR = Config.getPathSeparator() + "." + Config.getPathSeparator();
    private static final String CURRENT = ".";
    private static final Pattern starPattern = Pattern.compile("[\\*]+");

    public static List<File> resolvePath(File incPath, File cwd) {
        if (cwd == null) {
            cwd = new File(Config.getHomeDir());
        }
        if (incPath.toString().startsWith(CURRENT_WITH_SEPARATOR)) {
            incPath = new File(incPath.toString().substring(CURRENT_WITH_SEPARATOR.length()));
        }
        if (incPath.toString().startsWith(TILDE_WITH_SEPARATOR)) {
            incPath = Config.getHomeDir().endsWith(Config.getPathSeparator()) ? new File(Config.getHomeDir() + incPath.toString().substring(2)) : new File(Config.getHomeDir() + incPath.toString().substring(1));
        }
        if (incPath.toString().indexOf(126) == 0) {
            incPath = incPath.toString().length() > 1 ? new File(cwd.toString() + Config.getPathSeparator() + incPath.toString()) : new File(Config.getHomeDir());
        }
        if (incPath.toString().indexOf(SEPARATOR_CURRENT_SEPARATOR) > -1) {
            int index = incPath.toString().indexOf(SEPARATOR_CURRENT_SEPARATOR);
            incPath = index == 0 ? new File(incPath.toString().substring(SEPARATOR_CURRENT_SEPARATOR.length() - 1)) : new File(incPath.toString().substring(0, index) + incPath.toString().substring(index + 2, incPath.toString().length()));
        }
        if (incPath.toString().indexOf(ROOT) != 0 && incPath.toString().indexOf(DRIVER_SEPARATOR) == -1 && !cwd.toString().equals(ROOT)) {
            incPath = cwd.toString().endsWith(Config.getPathSeparator()) ? new File(cwd.toString() + incPath.toString()) : new File(cwd.toString() + Config.getPathSeparator() + incPath.toString());
        }
        if (incPath.toString().indexOf(PARENT_WITH_SEPARATOR) > -1) {
            String tmp = incPath.toString();
            while (tmp.indexOf(PARENT_WITH_SEPARATOR) > -1) {
                int index = tmp.indexOf(PARENT_WITH_SEPARATOR);
                if (index == 0) {
                    tmp = tmp.substring(PARENT_WITH_SEPARATOR.length());
                    continue;
                }
                File tmpFile = new File(tmp.substring(0, index));
                if ((tmpFile = tmpFile.getParentFile()) == null) {
                    tmpFile = new File(Config.getPathSeparator());
                }
                tmpFile = new File(tmpFile.toString() + tmp.substring(index + PARENT_WITH_SEPARATOR.length() - 1));
                tmp = tmpFile.toString();
            }
            incPath = new File(tmp);
        }
        if (incPath.toString().endsWith(PARENT)) {
            incPath = new File(incPath.toString().substring(0, incPath.toString().length() - PARENT.length()));
            if ((incPath = incPath.getParentFile()) == null) {
                incPath = new File(Config.getPathSeparator());
            }
        }
        if (incPath.toString().indexOf(42) > -1 || incPath.toString().indexOf(63) > -1) {
            PathCriteria pathCriteria = PathResolver.parsePath(incPath);
            if (incPath.toString().indexOf(SEPARATOR) > -1) {
                ArrayList<File> foundFiles = null;
                if (pathCriteria.getCriteria().equals(String.valueOf('*'))) {
                    foundFiles = new ArrayList<File>();
                    foundFiles.add(new File(pathCriteria.getParentPath()));
                } else {
                    foundFiles = PathResolver.findFiles(new File(pathCriteria.parentPath), pathCriteria.getCriteria(), false);
                }
                if (pathCriteria.childPath.length() == 0) {
                    return foundFiles;
                }
                ArrayList<File> outFiles = new ArrayList<File>();
                for (File f : foundFiles) {
                    if (!new File(f + Config.getPathSeparator() + pathCriteria.childPath).exists()) continue;
                    outFiles.add(new File(f + Config.getPathSeparator() + pathCriteria.childPath));
                }
                return outFiles;
            }
            if (incPath.toString().length() == 1) {
                List<File> foundFiles = PathResolver.findFiles(new File(pathCriteria.parentPath), pathCriteria.getCriteria(), false);
                if (pathCriteria.childPath.length() == 0) {
                    return foundFiles;
                }
            }
            return new ArrayList<File>();
        }
        ArrayList<File> fileList = new ArrayList<File>(1);
        fileList.add(incPath);
        return fileList;
    }

    private static List<File> parseWildcard(File incPath) {
        ArrayList<File> files = new ArrayList<File>();
        int index = -1;
        while (incPath.toString().indexOf(42) > -1) {
        }
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<File> findFiles(File incPath, String searchArgument, boolean findDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**");
        if (starPattern.matcher(searchArgument).matches()) {
            try (DirectoryStream<Path> stream2 = findDirectory ? Files.newDirectoryStream(incPath.toPath(), new DirectoryFilter()) : Files.newDirectoryStream(incPath.toPath(), new FileFilter());){
                for (Path p : stream2) {
                    files.add(p.toFile());
                }
                ArrayList<File> arrayList2 = files;
                return arrayList2;
            }
            catch (IOException e) {
                e.printStackTrace();
                return files;
            }
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(incPath.toPath(), searchArgument);){
            if (findDirectory) {
                for (Path p : stream) {
                    if (!Files.isDirectory(p, new LinkOption[0])) continue;
                    files.add(p.toFile());
                }
            } else {
                for (Path p : stream) {
                    files.add(p.toFile());
                }
            }
            ArrayList<File> arrayList = files;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }

    private static PathCriteria parsePath(File path) {
        int parentSeparatorIndex;
        int wildcardIndex;
        int index;
        int starIndex = path.toString().indexOf(42);
        int n = index = starIndex < (wildcardIndex = path.toString().indexOf(63)) || wildcardIndex < 0 ? starIndex : wildcardIndex;
        if (index == 0 && path.toString().length() == 1) {
            return new PathCriteria(String.valueOf(SEPARATOR), "", path.toString());
        }
        for (parentSeparatorIndex = index - 1; path.toString().charAt(parentSeparatorIndex) != SEPARATOR && parentSeparatorIndex > -1; --parentSeparatorIndex) {
        }
        int childSeparatorIndex = index + 1;
        if (childSeparatorIndex < path.toString().length()) {
            while (path.toString().charAt(childSeparatorIndex) != SEPARATOR && parentSeparatorIndex < path.toString().length()) {
                ++childSeparatorIndex;
            }
        }
        String parentPath = path.toString().substring(0, parentSeparatorIndex);
        String criteria = path.toString().substring(parentSeparatorIndex + 1, childSeparatorIndex);
        String childPath = path.toString().substring(childSeparatorIndex, path.toString().length());
        return new PathCriteria(parentPath, childPath, criteria);
    }

    static class PathCriteria {
        private final String parentPath;
        private final String childPath;
        private final String criteria;

        PathCriteria(String parentPath, String childPath, String criteria) {
            this.parentPath = parentPath;
            this.childPath = childPath;
            this.criteria = criteria;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public String getCriteria() {
            return this.criteria;
        }

        public String getChildPath() {
            return this.childPath;
        }
    }

    private static class FileFilter
    implements DirectoryStream.Filter<Path> {
        private FileFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.exists(entry, new LinkOption[0]);
        }
    }

    private static class DirectoryFilter
    implements DirectoryStream.Filter<Path> {
        private DirectoryFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    }
}

