/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.models.KeycloakTransaction;

public class JpaKeycloakTransaction
implements KeycloakTransaction {
    private static final Logger logger = Logger.getLogger(JpaKeycloakTransaction.class);
    protected EntityManager em;

    public JpaKeycloakTransaction(EntityManager em) {
        this.em = em;
    }

    public void begin() {
        this.em.getTransaction().begin();
    }

    public void commit() {
        try {
            logger.trace((Object)"Committing transaction");
            this.em.getTransaction().commit();
        }
        catch (PersistenceException e) {
            throw PersistenceExceptionConverter.convert(e.getCause() != null ? e.getCause() : e);
        }
    }

    public void rollback() {
        logger.trace((Object)"Rollback transaction");
        this.em.getTransaction().rollback();
    }

    public void setRollbackOnly() {
        this.em.getTransaction().setRollbackOnly();
    }

    public boolean getRollbackOnly() {
        return this.em.getTransaction().getRollbackOnly();
    }

    public boolean isActive() {
        return this.em.getTransaction().isActive();
    }
}

