/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class RobustLineIntersector
extends LineIntersector {
    @Override
    public void computeIntersection(Coordinate p, Coordinate p1, Coordinate p2) {
        this.isProper = false;
        if (Envelope.intersects(p1, p2, p) && Orientation.index(p1, p2, p) == 0 && Orientation.index(p2, p1, p) == 0) {
            this.isProper = true;
            if (p.equals(p1) || p.equals(p2)) {
                this.isProper = false;
            }
            this.result = 1;
            return;
        }
        this.result = 0;
    }

    @Override
    protected int computeIntersect(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean collinear;
        this.isProper = false;
        if (!Envelope.intersects(p1, p2, q1, q2)) {
            return 0;
        }
        int Pq1 = Orientation.index(p1, p2, q1);
        int Pq2 = Orientation.index(p1, p2, q2);
        if (Pq1 > 0 && Pq2 > 0 || Pq1 < 0 && Pq2 < 0) {
            return 0;
        }
        int Qp1 = Orientation.index(q1, q2, p1);
        int Qp2 = Orientation.index(q1, q2, p2);
        if (Qp1 > 0 && Qp2 > 0 || Qp1 < 0 && Qp2 < 0) {
            return 0;
        }
        boolean bl = collinear = Pq1 == 0 && Pq2 == 0 && Qp1 == 0 && Qp2 == 0;
        if (collinear) {
            return this.computeCollinearIntersection(p1, p2, q1, q2);
        }
        if (Pq1 == 0 || Pq2 == 0 || Qp1 == 0 || Qp2 == 0) {
            this.isProper = false;
            if (p1.equals2D(q1) || p1.equals2D(q2)) {
                this.intPt[0] = p1;
            } else if (p2.equals2D(q1) || p2.equals2D(q2)) {
                this.intPt[0] = p2;
            } else if (Pq1 == 0) {
                this.intPt[0] = new Coordinate(q1);
            } else if (Pq2 == 0) {
                this.intPt[0] = new Coordinate(q2);
            } else if (Qp1 == 0) {
                this.intPt[0] = new Coordinate(p1);
            } else if (Qp2 == 0) {
                this.intPt[0] = new Coordinate(p2);
            }
        } else {
            this.isProper = true;
            this.intPt[0] = this.intersection(p1, p2, q1, q2);
        }
        return 1;
    }

    private int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean p1q1p2 = Envelope.intersects(p1, p2, q1);
        boolean p1q2p2 = Envelope.intersects(p1, p2, q2);
        boolean q1p1q2 = Envelope.intersects(q1, q2, p1);
        boolean q1p2q2 = Envelope.intersects(q1, q2, p2);
        if (p1q1p2 && p1q2p2) {
            this.intPt[0] = q1;
            this.intPt[1] = q2;
            return 2;
        }
        if (q1p1q2 && q1p2q2) {
            this.intPt[0] = p1;
            this.intPt[1] = p2;
            return 2;
        }
        if (p1q1p2 && q1p1q2) {
            this.intPt[0] = q1;
            this.intPt[1] = p1;
            return q1.equals(p1) && !p1q2p2 && !q1p2q2 ? 1 : 2;
        }
        if (p1q1p2 && q1p2q2) {
            this.intPt[0] = q1;
            this.intPt[1] = p2;
            return q1.equals(p2) && !p1q2p2 && !q1p1q2 ? 1 : 2;
        }
        if (p1q2p2 && q1p1q2) {
            this.intPt[0] = q2;
            this.intPt[1] = p1;
            return q2.equals(p1) && !p1q1p2 && !q1p2q2 ? 1 : 2;
        }
        if (p1q2p2 && q1p2q2) {
            this.intPt[0] = q2;
            this.intPt[1] = p2;
            return q2.equals(p2) && !p1q1p2 && !q1p1q2 ? 1 : 2;
        }
        return 0;
    }

    private Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = this.intersectionSafe(p1, p2, q1, q2);
        if (!this.isInSegmentEnvelopes(intPt)) {
            intPt = new Coordinate(RobustLineIntersector.nearestEndpoint(p1, p2, q1, q2));
        }
        if (this.precisionModel != null) {
            this.precisionModel.makePrecise(intPt);
        }
        return intPt;
    }

    private void checkDD(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2, Coordinate intPt) {
        Coordinate intPtDD = CGAlgorithmsDD.intersection(p1, p2, q1, q2);
        boolean isIn = this.isInSegmentEnvelopes(intPtDD);
        System.out.println("DD in env = " + isIn + "  --------------------- " + intPtDD);
        if (intPt.distance(intPtDD) > 1.0E-4) {
            System.out.println("Distance = " + intPt.distance(intPtDD));
        }
    }

    private Coordinate intersectionSafe(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = Intersection.intersection(p1, p2, q1, q2);
        if (intPt == null) {
            intPt = RobustLineIntersector.nearestEndpoint(p1, p2, q1, q2);
        }
        return intPt;
    }

    private boolean isInSegmentEnvelopes(Coordinate intPt) {
        Envelope env0 = new Envelope(this.inputLines[0][0], this.inputLines[0][1]);
        Envelope env1 = new Envelope(this.inputLines[1][0], this.inputLines[1][1]);
        return env0.contains(intPt) && env1.contains(intPt);
    }

    private static Coordinate nearestEndpoint(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate nearestPt = p1;
        double minDist = Distance.pointToSegment(p1, q1, q2);
        double dist = Distance.pointToSegment(p2, q1, q2);
        if (dist < minDist) {
            minDist = dist;
            nearestPt = p2;
        }
        if ((dist = Distance.pointToSegment(q1, p1, p2)) < minDist) {
            minDist = dist;
            nearestPt = q1;
        }
        if ((dist = Distance.pointToSegment(q2, p1, p2)) < minDist) {
            minDist = dist;
            nearestPt = q2;
        }
        return nearestPt;
    }
}

