/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.core.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.CreateConfigCmd;
import com.github.dockerjava.api.command.CreateConfigResponse;
import java.util.Base64;
import java.util.Map;
import org.testcontainers.shaded.com.github.dockerjava.core.command.AbstrDockerCmd;
import org.testcontainers.shaded.com.google.common.base.Preconditions;

public class CreateConfigCmdImpl
extends AbstrDockerCmd<CreateConfigCmd, CreateConfigResponse>
implements CreateConfigCmd {
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Data")
    private String data;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;

    public String getName() {
        return this.name;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public CreateConfigCmdImpl(CreateConfigCmd.Exec exec) {
        super(exec);
    }

    public CreateConfigCmd withName(String name) {
        Preconditions.checkNotNull(name, "name was not specified");
        this.name = name;
        return this;
    }

    public CreateConfigCmd withData(byte[] data) {
        Preconditions.checkNotNull(data, "data was not specified");
        this.data = Base64.getEncoder().encodeToString(data);
        return this;
    }

    public CreateConfigCmd withLabels(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels was not specified");
        this.labels = labels;
        return this;
    }
}

