/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.ImageNameSubstitutor;
import org.testcontainers.utility.TestcontainersConfiguration;

final class ConfigurationFileImageNameSubstitutor
extends ImageNameSubstitutor {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationFileImageNameSubstitutor.class);
    private final TestcontainersConfiguration configuration;

    public ConfigurationFileImageNameSubstitutor() {
        this(TestcontainersConfiguration.getInstance());
    }

    @VisibleForTesting
    ConfigurationFileImageNameSubstitutor(TestcontainersConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public DockerImageName apply(DockerImageName original) {
        DockerImageName result = this.configuration.getConfiguredSubstituteImage(original).asCompatibleSubstituteFor(original);
        if (!result.equals(original)) {
            log.warn("Image name {} was substituted by configuration to {}. This approach is deprecated and will be removed in the future", (Object)original, (Object)result);
        }
        return result;
    }

    @Override
    protected String getDescription() {
        return this.getClass().getSimpleName();
    }
}

